/*	$OpenBSD: mktemp.c,v 1.5 1998/06/21 22:14:00 millert Exp $	*/

/*
 * Copyright (c) 1996, 2000 Todd C. Miller <Todd.Miller@courtesan.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint                                                              
static const char rcsid[] = "$Id: mktemp.c,v 1.2 2000/02/07 01:51:31 millert Exp $";
#endif /* not lint */                                                        

#include "config.h"

#include <stdio.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif /* STDC_HEADERS */
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <errno.h>

#include <extern.h>

#ifdef HAVE_PROGNAME
extern char *__progname;
#else
char *__progname;
#endif

static void
usage()
{
	(void) fprintf(stderr, "Usage: %s [-d] [-q] [-u] template\n",
	    __progname);
	exit(1);
}

int
main(argc, argv)
	int argc;
	char **argv;
{
	char *template;
	int c, uflag = 0, qflag = 0, makedir = 0;
	extern int optind;

#ifndef HAVE_PROGNAME
	__progname = argv[0];
#endif

	while ((c = getopt(argc, argv, "dqu")) != -1)
		switch(c) {
		case 'd':
			makedir = 1;
			break;
		case 'q':
			qflag = 1;
			break;
		case 'u':
			uflag = 1;
			break;
		case '?':
		default:
			usage();
	}

	if (argc - optind != 1)
		usage();

	if ((template = strdup(argv[optind])) == NULL) {
		if (!qflag)
			(void) fprintf(stderr, "%s: cannot allocate memory\n",
			    __progname);
		exit(1);
	}

	if (makedir) {
		if (MKDTEMP(template) == NULL) {
			if (!qflag) {
				(void) fprintf(stderr,
				    "%s: cannot make temp dir %s: %s\n",
				    __progname, template, strerror(errno));
			}
			exit(1);
		}

		if (uflag)
			(void) rmdir(template);
	} else {
		if (MKSTEMP(template) < 0) {
			if (!qflag) {
				(void) fprintf(stderr,
				    "%s: cannot create temp file %s: %s\n",
				    __progname, template, strerror(errno));
			}
			exit(1);
		}

		if (uflag)
			(void) unlink(template);
	}

	(void) puts(template);
	free(template);

	exit(0);
}
