.\"	$Id: mktemp.man,v 1.8 2001/10/01 17:06:25 millert Exp $
.\"
.\" Copyright (c) 1996, 2000, 2001 Todd C. Miller <Todd.Miller@courtesan.com>
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. The name of the author may not be used to endorse or promote products
.\"    derived from this software without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
.\" AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
.\" THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
.\" EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
.\" PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
.\" OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
.\" WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
.\" ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH MKTEMP 1 "30 September 2001"
.SH NAME
\fBmktemp\fP \- make temporary file name (unique)
.SH SYNOPSIS
\fBmktemp\fP [\fB\-V\fP] | [\fB\-dqtu\fP] [\fB\-p\fP \fIdirectory\fP] \fItemplate\fP
.SH DESCRIPTION
The
.B mktemp
utility takes the given file name template and overwrites a
portion of it to create a unique file name.
The template may be any file name with some number of
`Xs' appended to it, for example /tmp/temp.XXXXXXXXXX.
.PP
The trailing `Xs' are replaced with a combination
of the current process number and random letters.
The name chosen depends both on the number of `Xs' in the template
and the number of collisions with pre\-existing files.
The number of unique file names
.B mktemp
can return depends on the number of
`Xs' provided; ten `Xs' will result in
.B mktemp
testing roughly 26 ** 10 combinations.
.PP
If
.B mktemp
can successfully generate a unique file name, the file (or directory)
is created with file permissions such that it is only readable and writable
by its owner (unless the
.B \-u
flag is given) and the filename is printed to standard output.
.PP
.B mktemp
is provided to allow shell scripts to safely use temporary
files.  Traditionally, many shell scripts take the name of the program with
the PID as a suffix and use that as a temporary file name.
This kind of naming scheme is predictable and the race condition it creates
is easy for an attacker to win.
A safer, though still inferior approach
is to make a temporary directory using the same naming scheme.
While this does allow one to guarantee that a temporary file will not be
subverted, it still allows a simple denial of service attack.
For these reasons it is suggested that
.B mktemp
be used instead.
.PP
The options are as follows:
.TP
.B \-V
Print the version and exit.
.TP
.B \-d
Make a directory instead of a file.
.TP
.BI "\-p " directory
Use the specified
.I directory
as a prefix when generating the temporary file name.
The
.I directory
will be overridden by the user's
.SM TMPDIR
environment variable if it is set.
This option implies the
.B \-t
flag (see below).
.TP
.B \-q
Fail silently if an error occurs.
This is useful if
a script does not want error output to go to standard error.
.TP
.B \-t
Generate a temporary file rooted in a temporary directory.
The temporary directory is chosen as follows:
.RS
.IP \(bu
If the user's
.SM TMPDIR
environment variable is set, the directory contained therein is used.
.IP \(bu
Otherwise, if the
.B \-p
flag was given the specified directory is used.
.IP \(bu
If none of the above apply,
.I /tmp
is used.
.RE
.PP
In this mode, the
.B template
should be a directory component (as opposed to a full path) and thus
should not contain any forward slashes.
.TP
.B \-u
Operate in ``unsafe'' mode.
The temp file will be unlinked before
.B mktemp
exits.  This is slightly better than mktemp(3)
but still introduces a race condition.  Use of this
option is not encouraged.
.PP
The
.B mktemp
utility
exits with a value of 0 on success or 1 on failure.
.SH EXAMPLES
The following sh(1)
fragment illustrates a simple use of
.B mktemp
where the script should quit if it cannot get a safe
temporary file.
.RS
.nf

CMD=`basename $0`
TMPFILE=`mktemp /tmp/$CMD.XXXXXXXXXX` || exit 1
echo "program output" >> $TMPFILE

.fi
.RE
The same fragment with support for a user's
.SM TMPDIR
environment variable can be written as follows.
.RS
.nf

CMD=`basename $0`
TMPFILE=`mktemp \-t $CMD.XXXXXXXXXX` || exit 1
echo "program output" >> $TMPFILE

.fi
.RE
In some cases, it may be desirable to use a default temporary directory
other than
.I /tmp.
In this example the temporary file will be created in
.I /extra/tmp
unless the user's
.SM TMPDIR
environment variable specifies otherwise.
.RS
.nf

CMD=`basename $0`
TMPFILE=`mktemp \-t \-p /extra/tmp $CMD.XXXXXXXXXX` || exit 1
echo "program output" >> $TMPFILE

.fi
.RE
In some cases, we want the script to catch the error.
For instance, if we attempt to create two temporary files and
the second one fails we need to remove the first before exiting.
.RS
.nf

CMD=`basename $0`
TMP1=`mktemp \-t $CMD.1.XXXXXXXXXX` || exit 1
TMP2=`mktemp \-t $CMD.2.XXXXXXXXXX`
if [ $? \-ne 0 ]; then
	rm \-f $TMP1
	exit 1
fi

.fi
.RE
Or perhaps you don't want to exit if
.B mktemp
is unable to create the file.
In this case you can protect that part of the script thusly.
.RS
.nf

CMD=`basename $0`
TMPFILE=`mktemp \-t $CMD.XXXXXXXXXX` && {
	# Safe to use $TMPFILE in this block
	echo data > $TMPFILE
	...
	rm \-f $TMPFILE
}

.fi
.RE
.SH ENVIRONMENT
.IP TMPDIR 8
directory in which to place the temporary file when in
.B \-t
mode
.SH SEE ALSO
.BR mkdtemp (3),
.BR mkstemp (3),
.BR mktemp (3)
.SH HISTORY
The
.B mktemp
utility appeared in OpenBSD 2.1.
