
/*****************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
*****************************************************************************/

/*****************************************************************************
**
**  File:    cmp_filter.h
**  Date:    September 17, 2003
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a compare filter object
**           used to filter out deltas from the logs.
**
*****************************************************************************/

#ifndef CMP_FILTER_H
#define CMP_FILTER_H


#define CMP_FILTER_TYPE_INCLUDE_ONLY    0x1
#define CMP_FILTER_TYPE_EXCLUDE         0x2

typedef enum
{
    /* UNIX 1 */

    ATTR_CHECKSUM      = 1 << 0,
    ATTR_DEVICE        = 1 << 1,
    ATTR_INODE         = 1 << 2,
    ATTR_PERMISSIONS   = 1 << 3,
    ATTR_LINKS         = 1 << 4,
    ATTR_UID           = 1 << 5,
    ATTR_GID           = 1 << 6,
    ATTR_MTIME         = 1 << 7,
    ATTR_ATIME         = 1 << 8,
    ATTR_CTIME         = 1 << 9,
    ATTR_DEVICE_TYPE   = 1 << 10,
    ATTR_BYTES         = 1 << 11,
    ATTR_BLOCKS        = 1 << 12,
    ATTR_BLOCK_SIZE    = 1 << 13,

    /* WINNT */

    ATTR_OWNER_SID       = 1 << 14,
    ATTR_GROUP_SID       = 1 << 15,
    ATTR_WIN32_FILE      = 1 << 16,

    /* new and missing. */

    ATTR_NEW           = 1 << 17,
    ATTR_MISSING       = 1 << 18

} OSI_ATTR_MASK;

struct n_keywords
{
    char *word;
    int  type;
};

//extern struct n_keywords cmp_keywords[];
//extern struct n_keywords cmp_descriptions[];


typedef struct OSI_CMP_FILTER
{
    char host[MAX_HOSTNAME_LENGTH];
    char path[MAX_PATH_LENGTH];

    osi_uint64 type; 
    osi_uint64 mask;
    
} OSI_CMP_FILTER;

void wrap_cmp_filter( OSI_CMP_FILTER *filter );
void unwrap_cmp_filter( OSI_CMP_FILTER *filter );

unsigned int pack_cmp_filter( OSI_CMP_FILTER *filter, char *buffer,
                                 int buffer_size );

void unpack_cmp_filter( OSI_CMP_FILTER *filter, char *buffer,
                           int buffer_size );


void print_cmp_filter( OSI_CMP_FILTER *filter );
void print_cmp_attribute_mask( osi_uint64 attr_list );
void print_valid_cmp_filter_attributes();


char * osi_get_name_for_cmp_attribute( osi_uint64 attr );
unsigned long mask_from_cmp_keywords( const char *keywords );


#endif
