
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      configuration.h
**    Author:    Brian Wotring
**
**    Date:      June 22, 2001.
**    Project:   osiris
**
******************************************************************************/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H


/* config file constants. */

#define CONFIG_MAX_ERRORS         5
#define MAX_LINE_LENGTH           1000
#define MAX_CONFIG_NAME_LENGTH    255
#define MAX_CONFIG_ID_LENGTH	  10

/* hash types. */

#define HASH_NULL       0
#define HASH_DEFAULT 	HASH_MD5
#define HASH_MD5     	1
#define HASH_SHA     	2
#define HASH_RIPEMD  	3

/* config keyword types */

#define CONFIG_KEYWORD_UNKNOWN          -1
#define CONFIG_KEYWORD_NULL              0
#define CONFIG_KEYWORD_RECURSIVE         1
#define CONFIG_KEYWORD_FOLLOWLINKS       2
#define CONFIG_KEYWORD_HASH              3
#define CONFIG_KEYWORD_INCLUDEALL        4
#define CONFIG_KEYWORD_EXCLUDEALL        5
#define CONFIG_KEYWORD_COMMENT           6

#define CONFIG_KEYWORD_DIRECTORY_START   7
#define CONFIG_KEYWORD_DIRECTORY_END     8
#define CONFIG_KEYWORD_INCLUDE           9
#define CONFIG_KEYWORD_EXCLUDE          10
#define CONFIG_KEYWORD_NOENTRY          11
#define CONFIG_KEYWORD_NAME             12
#define CONFIG_KEYWORD_SYSTEM_START     13
#define CONFIG_KEYWORD_SYSTEM_END       14
#define CONFIG_KEYWORD_PARAM            15


/* action types. */

#define ACTION_TYPE_UNKNOWN        	0
#define ACTION_TYPE_INCLUDE        	1
#define ACTION_TYPE_INCLUDE_ALL    	2
#define ACTION_TYPE_EXCLUDE        	3
#define ACTION_TYPE_EXCLUDE_ALL    	4
#define ACTION_TYPE_NO_ENTRY       	5


/*
extern struct keywords config_keywords[];
extern struct keywords boolean_keywords[];
extern struct keywords hash_keywords[];
extern char * valid_hash_values[];
extern char * valid_boolean_values[];
*/

/* config file structures. */

typedef struct action
{
    int type;
    OSI_FILTER action_filter;

} action;

/* module parameter. */

typedef struct param
{
    char name[MAX_MODULE_NAME_LENGTH];
    char value[MAX_PATH_LENGTH];

} param;

typedef struct block
{
    char directory[MAX_PATH_LENGTH];

    osi_bool recursive;
    osi_bool follow_links;

    osi_list actions;
    unsigned int hash;
    string_list *no_entry_list;

} block;

typedef struct module
{
    char name[MAX_MODULE_NAME_LENGTH];
    osi_list params;

} module;


typedef struct OSI_SCAN_CONFIG
{
    char name[MAX_CONFIG_NAME_LENGTH];

    string_list *data;
    string_list *block_names;

    int state;
    unsigned char id[MAX_CONFIG_ID_LENGTH];
    
    unsigned int error_count;
    unsigned int warning_count;

    osi_list modules;
    osi_list blocks;

    osi_bool print_errors_on_verify;

} OSI_SCAN_CONFIG;


/* public methods relating to config structures. */

OSI_SCAN_CONFIG * osi_config_new();
void osi_config_destroy( OSI_SCAN_CONFIG *cfg );

osi_bool osi_config_receive_first( OSI_SCAN_CONFIG *cfg, unsigned char *data,
                                   int data_length );

osi_bool osi_config_receive( OSI_SCAN_CONFIG *cfg, unsigned char *data,
                             int data_length );

osi_bool osi_config_receive_last( OSI_SCAN_CONFIG *cfg, unsigned char *data,
                                  int data_length );

osi_bool osi_config_parse( OSI_SCAN_CONFIG *cfg );
osi_bool osi_config_verify( OSI_SCAN_CONFIG *cfg );

osi_bool osi_config_read_from_file( OSI_SCAN_CONFIG  *cfg,
                                    const char *file_path );

osi_bool osi_config_write_to_file( OSI_SCAN_CONFIG *cfg,
                                   const char *file_path );

osi_bool osi_config_generate_id( OSI_SCAN_CONFIG *cfg );

block * osi_config_get_global_block( OSI_SCAN_CONFIG *cfg );
block * osi_config_get_first_block( OSI_SCAN_CONFIG *cfg );
block * osi_config_get_next_block( OSI_SCAN_CONFIG *cfg, block *current_block );
block * get_block_with_name( OSI_SCAN_CONFIG *cfg, char *name );
module * get_module_with_name( OSI_SCAN_CONFIG *cfg, char *name );

action * get_action_from_block_with_filter( block *config_block,
                                            int filter_type,
                                            char *filter_argument );

/* semi-public */

osi_bool osi_config_parse_globals( OSI_SCAN_CONFIG *cfg );
osi_bool osi_config_parse_non_globals( OSI_SCAN_CONFIG *cfg );

osi_bool osi_config_verify_semantics( OSI_SCAN_CONFIG *cfg );
osi_bool osi_config_verify_syntax( OSI_SCAN_CONFIG *cfg );

void osi_config_dump( OSI_SCAN_CONFIG *cfg );
void osi_config_dump_block( block *configuration_block );
void osi_config_dump_action( action *configuration_action );
void osi_config_dump_module( module *configuration_module );

/* internal config parsing and verification methods. */

int get_keyword_type( char *string );

int get_hash_value( char *keyword, unsigned int *value );
int get_boolean_value( char *keyword, osi_bool *value );
int get_name_value( OSI_SCAN_CONFIG *cfg, char *line );

osi_bool get_module_parameter( OSI_SCAN_CONFIG *cfg, char *line );

char * verify_single_value( char *value, char *valid_values[] );

void print_config_error( OSI_SCAN_CONFIG *cfg, int line_number,
                         char *line, char *error, ... );

char * get_hash_name_from_type( int type );

/* internal block and action methods. */

block *create_block();
action *create_action();
module *create_module();
param *create_param();

block *new_block_from_block( block *parent_block );

void destroy_block( block *config_block );
void destroy_action( action *config_action );
void destroy_module( module *config_module );
void destroy_param( param *module_param );

#endif

