
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_notify.h
**  Date:    July 1, 2003
**
**  Author:  Brian Wotring
**  Purpose: notify admin of scan logs, initially this will be via email.
**
******************************************************************************/

#ifndef MD_NOTIFY_H_
#define MD_NOTIFY_H_

void md_notify_admin( const char *email, OSI_DB_CTX *context,osi_bool show_url);

void md_notify_admin_session_rekey( const char *host, const char *email );

void md_notify_admin_scan_failed( const char *host,
                                   const char *email,
                                   unsigned long scheduled_time,
                                   const char *message );

osi_bool  md_notify_send_test( const char *email, OSI_ERROR *error );

#endif

