#!/bin/sh

MKDIR=`which mkdir` 
STRIP=`which strip`
SYSTEM=`uname -s`

case ${SYSTEM} in
    AIX*)
        ARCHITECTURE="aix"
        ;;
    Linux*)
        ARCHITECTURE=`uname -p | tr "\ " "-"`
        ;;
    *)
        ARCHITECTURE=`uname -p`
        ;;
esac

RELEASE=`uname -r`

TAR=`which tar`
GZIP=`which gzip`

RM=`which rm`
CP=`which cp`
CHMOD=`which chmod`

VERSION=`cat version.h | grep version_string | awk '{print $3}'`

DIR_NAME="osiris-agent-${VERSION}"
PACKAGE_NAME="${DIR_NAME}-${ARCHITECTURE}-${SYSTEM}-${RELEASE}.tar"
TARBALL="src/install/${PACKAGE_NAME}"

echo "-------------------------------------------------------------------------"
echo "building release tarball: ${TARBALL}"

# make a temporary directory.

${MKDIR} ./${DIR_NAME}
cd ./${DIR_NAME}

# copy in version file.

${CP} ../version.h .

# copy in any pre-provisioned root cert file.

if [ -f ../osiris_root.pem ]; then
    ${CP} ../osiris_root.pem .
fi

# copy in the binaries, then strip them.

if [ -f ../../cli/osiris ]; then 
${CP} ../../cli/osiris .
${STRIP} ./osiris
fi

${CP} ../../osirisd/osirisd .
${STRIP} ./osirisd

# copy the LICENSE file.

${CP} ../../../LICENSE .

# copy in the installer script.

${CP} ../install.sh .
${CHMOD} ug+x ./install.sh

# copy in platform specific crap.

case ${SYSTEM} in
Linux)
    ${CP} -rf ../linux .
    ;;
Darwin)
    ${CP} -rf ../darwin .
    ;;
FreeBSD)
    ${CP} -rf ../freebsd .
    ;;
NetBSD)
    ${CP} -rf ../netbsd .
    ;;
SunOS*)
    ${CP} -rf ../sunos .
    ;;
AIX*)
    ${CP} -rf ../aix .
    ;;
IRIX*)
    ${CP} -rf ../irix .
    ;;
*)
    ;;
esac


echo "installer package contents:"

ls -lA
cd ..

${TAR} cf ${PACKAGE_NAME} ${DIR_NAME}
${GZIP} ${PACKAGE_NAME}

# remove temporary directory.

${RM} -rf ${DIR_NAME}

echo "-------------------------------------------------------------------------"
echo "installer package created."
echo ""

