
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_hosts.h
**  Date:    May 24, 2002
**
**  Author:  Brian Wotring
**  Purpose: interact with local file system to read in host information from
**	         hosts directory.
**
******************************************************************************/

#ifndef MD_HOSTS_H_
#define MD_HOSTS_H_

/* host directory information. */

#define HOST_CONFIG_KEY_VALUE_SEPARATOR   '='
#define HOST_CONFIG_COMMENT_LINE	      '#'

#define MAX_HOST_CONFIG_LINE_LENGTH	      512
#define MAX_HOST_CONFIG_KEY_LENGTH	      256

#define HOST_SESSION_KEY_LENGTH	          64
#define HOST_SESSION_KEY_HASH_LENGTH      ( ( SHA_DIGEST_LENGTH * 2 ) + 1 )

#define HOST_CONFIG_PERMISSIONS		      0600


/* this is the main structure used to store all host */
/* related information from the local filesystem.    */

typedef struct OSI_HOST
{
    char name[MAX_HOST_BRIEF_NAME_LENGTH];
    char host[MAX_HOST_BRIEF_NAME_LENGTH];
    char description[MAX_HOST_BRIEF_DESCRIPTION_LENGTH];
    char session_key[HOST_SESSION_KEY_HASH_LENGTH];
    char base_db[MAX_HOST_BRIEF_NAME_LENGTH];
    char notify_email[MAX_HOST_BRIEF_NOTIFY_EMAIL_LENGTH];
    char config[MAX_HOST_BRIEF_NAME_LENGTH];

    osi_uint64 enabled;
    osi_uint64 type;

    osi_uint64 file_log_enabled;
    osi_uint64 db_flags;

    osi_uint64 notify_enabled;
    osi_uint64 notify_flags;

    osi_uint64 schedule_start;
    osi_uint64 schedule_period;

    osi_uint64 port;
    
    osi_list configs;
    osi_list databases;
    osi_list logs;

} OSI_HOST;



/* all function prototypes for dealing with hosts.  most of   */
/* these methods deal with the local repository, and make     */
/* use of the management library (libosirism) for the details */
/* of parsing and writing the host related structures.        */

OSI_HOST * osi_host_new();
void osi_host_destroy( OSI_HOST *host );

void osi_set_host_defaults( OSI_HOST *host );

osi_list osi_read_hosts();
osi_list osi_read_host_briefs();

OSI_HOST * osi_read_host( const char *name );
osi_bool osi_write_host( OSI_HOST *host );
osi_bool osi_remove_host( const char *name );

OSI_HOST_BRIEF * osi_read_host_brief( const char *name );
osi_bool osi_write_host_brief( OSI_HOST_BRIEF *host_brief );

osi_bool osi_hosts_directory_exists();
osi_bool osi_create_hosts_directory();

osi_bool osi_host_exists( const char *name );
osi_bool osi_host_brief_from_host( OSI_HOST *host, OSI_HOST_BRIEF *brief );

OSI_HOST_CONFIG * osi_host_read_host_config_with_name( const char *name );

osi_bool osi_host_write_host_config_with_name( OSI_HOST_CONFIG *config,
                                               const char *name );

unsigned long osi_host_get_config_count( const char *name );
unsigned long osi_host_get_database_count( const char *name );
unsigned long osi_host_get_log_count( const char *name );

osi_bool osi_host_brief_set_base_db( OSI_HOST_BRIEF *host, char *dbname );

#endif
