
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    osirismd.h
**  Date:    May 19, 2002
**
**  Author:  Brian Wotring
**  Purpose: management daemon header file.
**
******************************************************************************/

#ifndef OSIRISMD_H_
#define OSIRISMD_H_

/* program version and name. */

#define PROGRAM_NAME     	"osirismd"

/* paramaters for server process. */

#define LISTEN_QUEUE_MAX     5

/* macros for selecting on important sockets. */

#define INCOMING_CONTROL_REQUEST()	( FD_ISSET( control_socket, &read_set ) )
#define INCOMING_HTTP_REQUEST()     ( FD_ISSET( http_socket, &read_set ) )
#define INCOMING_AUTH_DB_EVENT()    ( FD_ISSET( user_pipe[0], &read_set ) )
#define INCOMING_RESTART_EVENT()    ( FD_ISSET( restart_pipe[0], &read_set ) )

/* paramaters for windows service. */

#ifdef WIN32
#define THREAD_FUNCTION_TYPE unsigned __stdcall
#define THREAD_FUNCTION_RETURN 0
#else
#define THREAD_FUNCTION_TYPE void
#define THREAD_FUNCTION_RETURN
#endif

/* flag for being daemon, used only for windows. */

osi_bool run_as_daemon = FALSE;

/* global for syslog write operations. */

#ifdef WIN32
HANDLE event_source = NULL;
#else
int syslog_facility = LOG_DAEMON;
#endif

/* signals. */

static volatile osi_atomic_t received_sigint  = 0;
static volatile osi_atomic_t received_sigterm = 0;
static volatile osi_atomic_t received_sighup  = 0;
static volatile osi_atomic_t received_sigchld = 0;
static volatile osi_atomic_t received_sigpipe = 0;
static volatile osi_atomic_t received_sigkill = 0;

static volatile osi_atomic_t scheduler_terminated = 0;
static volatile osi_atomic_t daemon_terminated = 0;

/* paramaters for SSL */

#define OSIRISMD_CIPHER_LIST "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH"
#define OSIRISMD_SSL_OPTIONS ( SSL_OP_ALL|SSL_OP_NO_SSLv2|SSL_OP_SINGLE_DH_USE )

#define OSIRISMD_SERVER_CERT_CHAIN_DEPTH   	10
#define OSIRISMD_RSA_KEY_SIZE              	2048

#define DEFAULT_ROOT_CERT_PERMISSIONS       0644
#define DEFAULT_CERT_PERMISSIONS           	0600

#define DEFAULT_CERT_CN			   	"Osiris Management Console"
#define DEFAULT_CERT_C				"US"
#define DEFAULT_CERT_OU				"Osiris Host Integrity System"

SSL_CTX *ssl_context    = NULL;
static BIO *bio_error   = NULL;

/* server and socket data. */

fd_set read_set;

int control_socket	          = 0;
int control_connection_socket = 0;

int http_socket               = 0;
int http_connection_socket    = 0;

SSL *http_connection_ssl      = NULL;
SSL *control_connection_ssl   = NULL;

/* for communication purposes. */

#ifndef WIN32
pid_t pid;
pid_t scheduler_pid;
pid_t log_pid;
#endif

int user_pipe[2];
int schedule_pipe[2];
int restart_pipe[2];
int log_pipe[2] = { -1,-1 };

char config_file_path[MAX_PATH_LENGTH]     = DEFAULT_CONFIG_PATH;
char root_path[MAX_PATH_LENGTH]            = OSIRISMD_ROOT_DIR;

char cert_path[MAX_PATH_LENGTH]	           = "";
char cert_file[MAX_PATH_LENGTH]            = "";

char private_key_path[MAX_PATH_LENGTH]     = "";
char private_key_file[MAX_PATH_LENGTH]     = "";

char auth_db_path[MAX_PATH_LENGTH]         = "";
char shared_configs_path[MAX_PATH_LENGTH]  = "";

char cmp_filter_db_path[MAX_PATH_LENGTH] = "";

/* config structure for this daemon. */

OSI_MANAGEMENT_CONFIG *config = NULL;

/* function prototypes. */

void startup_winsock();
void parse_arguments( int argument_count, char *argument_list[] );

THREAD_FUNCTION_TYPE run( void *unused );

void become_windows_service();
void parse_configuration_file();

void verify_root_directory();
void verify_host_directories();

void initialize_root_path();
void initialize_log();
void initialize_signals();
void initialize_ssl();
void initialize_pipes();

void handle_sigint( int signal );
void handle_sigterm( int signal );
void handle_sighup( int signal );
void handle_sigchld( int signal );
void handle_sigpipe( int signal );
void handle_sigkill( int signal );

void check_for_signals();

void fork_daemon_process();
void start_scheduler();

void start_servers();
void start_log_application();
void shutdown_servers();
void shutdown_scheduler();

void shutdown_ssl();
void handle_restart();

void signal_restart_needed();

void process();
void halt( int code );

osi_bool client_address_is_allowed( const char *ipstr );
osi_bool generate_keypair();

osi_bool make_certificate( X509 **x509p, EVP_PKEY **pkeyp, int bits,
                           int serial, int days );

void print_usage();
int ssl_verify_callback( int ok, X509_STORE_CTX *store );

void process_control_message( MESSAGE *message );

void process_new_client( int client_socket );
void process_new_http_client( int client_socket );

void wait_for_data();

#endif
