
/*****************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
*****************************************************************************/

/******************************************************************************
**
**  File:    management_config.h
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**  Purpose: common mgmt configuration module to read and parse mgmt
**           configuration from a flat file.
**
******************************************************************************/

#ifndef MANAGEMENT_CONFIG_H_
#define MANAGEMENT_CONFIG_H_


/* management daemon config file. */

/* The following line may be altered to provide
** another level of security. However, obscurity is
** by no means a security measure to rely on in a
** high-security environment. Be sure to document the
** changes made here in the company security policy.
*/

#define MANAGEMENT_CONFIG_FILE_NAME 			"osirismd.conf"
#define MANAGEMENT_CONFIG_FILE_PERMISSIONS		0600


/* host directory information. */

#define MANAGEMENT_CONFIG_KEY_VALUE_SEPARATOR		'='
#define MANAGEMENT_CONFIG_COMMENT_LINE	  	        '#'


#define MANAGEMENT_CONFIG_KEYWORD_COMMENT	       -1
#define MANAGEMENT_CONFIG_KEYWORD_UNKNOWN   	  	0
#define MANAGEMENT_CONFIG_KEYWORD_SYSLOG_FACILITY	1
#define MANAGEMENT_CONFIG_KEYWORD_CONTROL_PORT		2
#define MANAGEMENT_CONFIG_KEYWORD_AUTHORIZED_HOST	3
#define MANAGEMENT_CONFIG_KEYWORD_NOTIFY_EMAIL      4
#define MANAGEMENT_CONFIG_KEYWORD_NOTIFY_SMTP_HOST  5
#define MANAGEMENT_CONFIG_KEYWORD_NOTIFY_SMTP_PORT  6
#define MANAGEMENT_CONFIG_KEYWORD_HTTP_PORT         7
#define MANAGEMENT_CONFIG_KEYWORD_HTTP_HOST         8
#define MANAGEMENT_CONFIG_KEYWORD_HOSTS_DIRECTORY   9
#define MANAGEMENT_CONFIG_KEYWORD_NOTIFY_APP        10

#define MAX_MANAGEMENT_CONFIG_LINE_LENGTH	        512
#define MAX_MANAGEMENT_CONFIG_KEY_LENGTH	        256
#define MAX_NOTIFY_EMAIL_LENGTH                     255
#define MAX_NOTIFY_SMTP_HOST_LENGTH                 255
#define MAX_HTTP_HOST_LENGTH                        255

#define MAX_SYSLOG_FACILITY_LENGTH                  15

/* defaults. */

#define DEFAULT_SYSLOG_FACILITY				"DAEMON"
#define DEFAULT_AUTHORIZED_HOSTS			"127.0.0.1"

#define DEFAULT_NOTIFY_SMTP_HOST            "127.0.0.1"
#define DEFAULT_NOTIFY_SMTP_PORT            25

#define DEFAULT_HOSTS_DIRECTORY             ""


/* management daemon's configuration structure */

typedef struct management_config
{
    char syslog_facility[MAX_SYSLOG_FACILITY_LENGTH];
    
    int control_port;
    int http_port;

    char http_host[MAX_HTTP_HOST_LENGTH];
    char notify_email[MAX_NOTIFY_EMAIL_LENGTH];
    char notify_smtp_host[MAX_NOTIFY_SMTP_HOST_LENGTH];
    char notify_app[MAX_PATH_LENGTH];
    unsigned int notify_smtp_port;

    char hosts_directory[MAX_PATH_LENGTH];
    
    string_list *authorized_hosts;
    string_list *data;
    
} OSI_MANAGEMENT_CONFIG;


struct m_keywords
{
    char *word;
    int  type;
};


/* function prototypes. */

OSI_MANAGEMENT_CONFIG * osi_management_config_new();
void osi_management_config_destroy( OSI_MANAGEMENT_CONFIG *config );

void osi_management_config_set_defaults( OSI_MANAGEMENT_CONFIG *config );
OSI_MANAGEMENT_CONFIG * osi_management_config_new_from_file( 
                                                const char *filepath );

osi_bool osi_management_config_receive_first( OSI_MANAGEMENT_CONFIG *config,
                                              unsigned char *data,
                                              int data_length );

osi_bool osi_management_config_receive( OSI_MANAGEMENT_CONFIG *config,
                                        unsigned char *data, int data_length );

osi_bool osi_management_config_receive_last( OSI_MANAGEMENT_CONFIG *config,
                                             unsigned char *data,
                                             int data_length );

osi_bool osi_management_config_read_file( const char *filepath,
                                          OSI_MANAGEMENT_CONFIG *config );

osi_bool osi_management_config_write_file( const char *root_path,
                                           OSI_MANAGEMENT_CONFIG *config );

osi_bool osi_management_config_sync( OSI_MANAGEMENT_CONFIG *config );

/* utility functions to parse the config file. */

osi_bool parse_management_config_line( char *line,
                                       OSI_MANAGEMENT_CONFIG *config );

int get_management_config_line_type( char *string );

osi_bool get_management_config_line_value( char *line, char *value,
                                           int value_size );

#ifndef WIN32

unsigned int get_syslog_facility_number( char *name );
const char * get_syslog_facility_name( int value );
#endif

#endif
