
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      utilities.h
**    Author:    Brian Wotring
**
**    Date:      June 22, 2001.
**    Project:   osiris
**
******************************************************************************/

#ifndef UTILITIES_H
#define UTILITIES_H

#include "osi_common.h"


#ifdef WORDS_BIGENDIAN

#define OSI_HTONLL(x)   (x)
#define OSI_NTOHLL(x)   (x)

#else

#define OSI_HTONLL(x)   ( byte_swap64(x) )
#define OSI_NTOHLL(x)   ( byte_swap64(x) )

#endif

#define MAXIMUM( first, second )    ( ( first > second ) ? first : second )
#define MINIMUM( first, second )    ( ( first > second ) ? second : first )


/* memory  operations. */

void osi_free( void *memory );
void *osi_malloc( size_t size );

/* string utility functions. */

char * trim_white_space( char *string );
char * trim_quotes( char *string );

char * get_string_up_to_token( char *string, char *result,
                               int result_size, char token );

char * get_token( char *string, char *buffer, int buffer_size );

void lowercase_string( char *string );
char * escape_filename( char *file_path, char *buffer, int buffer_size );

/* safe string wrappers. */

size_t osi_strlcpy( char *dst, const char *src, size_t nchars );
size_t osi_strlcat( char *dst, const char *src, size_t nchars );

size_t osi_vsnprintf( char *str, size_t nchars, const char  *format,
                      va_list ap );

size_t osi_snprintf( char *str, size_t nchars, const char *format, ... );

/* safe fopen wrapper. */

FILE *osi_fopen( const char *file_name, const char *flags, mode_t mode );

#ifndef WIN32
void get_file_attribute_string( char *buffer, int buffer_size,
                                mode_t attributes );
#endif

/* output functions */

void osi_print_stdout( const char *message, ... );
void osi_print_stderr( const char *message, ... );

/* 64 bit field conversions. */

osi_uint64 byte_swap64( osi_uint64 value );

/* misc. */

void osi_sleep( int seconds );

long osi_get_time();
int osi_create_process();
char * osi_time_to_string( long time );

#endif
