
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    host_brief.h
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a host that can be transported in a message.
**
******************************************************************************/

#ifndef HOST_BRIEF_H
#define HOST_BRIEF_H

#define MAX_HOST_BRIEF_NAME_LENGTH	       128
#define MAX_HOST_BRIEF_DESCRIPTION_LENGTH  255
#define MAX_HOST_BRIEF_NOTIFY_EMAIL_LENGTH 128
#define MAX_HOST_BRIEF_DB_NAME_LENGTH      10
#define MAX_HOST_BRIEF_CONFIG_LENGTH       64

#define HOST_SESSION_KEY_LENGTH	  	       64
#define HOST_SESSION_KEY_HASH_LENGTH       ( ( SHA_DIGEST_LENGTH * 2 ) + 1 )


/* this is a condensed host structure used for communication  */
/* between the management daemon and a managment application. */

typedef struct OSI_HOST_BRIEF
{
    osi_uint64 enabled;
    osi_uint64 type;

    osi_uint64 file_log_enabled;
    osi_uint64 db_flags;

    osi_uint64 notify_enabled;
    osi_uint64 notify_flags;
    
    osi_uint64 config_count;
    osi_uint64 database_count;

    osi_uint64 schedule_start;
    osi_uint64 schedule_period;

    osi_uint64 port;
    osi_uint64 unused;
      
    char name[MAX_HOST_BRIEF_NAME_LENGTH];
    char host[MAX_HOST_BRIEF_NAME_LENGTH];
    char description[MAX_HOST_BRIEF_DESCRIPTION_LENGTH];
    char session_key[HOST_SESSION_KEY_LENGTH];
    char base_db[MAX_HOST_BRIEF_DB_NAME_LENGTH];
    char notify_email[MAX_HOST_BRIEF_NOTIFY_EMAIL_LENGTH];
    char config[MAX_HOST_BRIEF_CONFIG_LENGTH];

} OSI_HOST_BRIEF;


void wrap_host_brief( OSI_HOST_BRIEF *host );
void unwrap_host_brief( OSI_HOST_BRIEF *host );

void osi_set_host_brief_defaults( OSI_HOST_BRIEF *host_brief );

#endif
