
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_auth.h
**  Date:    June 3, 2002
**
**  Author:  Brian Wotring
**  Purpose: handle interactions with the user authentication database
**           for this management daemon.
**
******************************************************************************/

#ifndef MD_AUTH_H_
#define MD_AUTH_H_


/* The following line is where to change the default
** administrative account before the build process.
**
** It is highly recommended for high-security installations
** that this is changed according to the definitions set
** forth in the company security policy.
*/
#define ADMIN_USER_NAME "admin"


void md_auth_load_database();
void md_auth_unload_database();
void md_auth_reload_database();

void md_auth_read();
void md_auth_signal_update();

osi_bool md_auth_authenticate( OSI_AUTH_CONTEXT *auth_context );
osi_bool md_auth_create_database( const char *auth_db_path );

osi_bool md_auth_set_entry( const char *user, const char *pass );
osi_bool md_auth_del_entry( const char *user );
osi_bool md_auth_entry_exists( const char *user );

osi_list md_auth_get_list();

#endif

