
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    error.h
**  Date:    June 2, 2002
**
**  Author:  Brian Wotring
**  Purpose: central error reference for all osiris applications.
**
******************************************************************************/

#ifndef ERROR_H_
#define ERROR_H_


#define MAX_ERROR_MESSAGE_LENGTH 	512


/* message error codes. */

#define OSI_ERROR_UNKNOWN		   -1L
#define OSI_OK						1L

#define MESSAGE_OK					OSI_OK
#define OSI_DB_OK					OSI_OK
#define OSI_FILE_OK					OSI_OK

#define OSI_ERROR_NULL_ARGUMENT				2L

#define OSI_ERROR_SOCKET_CLOSED		 		10L
#define OSI_ERROR_UNABLE_TO_CONNECT        	11L
#define OSI_ERROR_NO_RESPONSE	        	12L
#define OSI_ERROR_INVALID_RESPONSE			13L

#define OSI_ERROR_SCAN_START_FAILED			20L
#define OSI_ERROR_NO_CONFIG			    	21L
#define OSI_ERROR_DAEMON_NOT_IDLE	       	22L
#define OSI_ERROR_NO_SCANNING_PROCESS      	23L
#define OSI_ERROR_NO_PRIVLEDGES				24L

#define OSI_ERROR_READ_HOSTS_FAILED	       	30L
#define OSI_ERROR_NO_HOST_SPECIFIED	       	31L
#define OSI_ERROR_NO_CONFIG_SPECIFIED		32L
#define OSI_ERROR_NO_DB_SPECIFIED			33L
#define OSI_ERROR_NO_CONFIGS		       	34L
#define OSI_ERROR_NO_HOSTS                 	35L
#define OSI_ERROR_HOST_DOES_NOT_EXIST		36L
#define OSI_ERROR_CONFIG_DOES_NOT_EXIST		37L
#define OSI_ERROR_DATABASE_DOES_NOT_EXIST	38L
#define OSI_ERROR_CONFIG_IS_EMPTY			39L
#define OSI_ERROR_HOST_EXISTS				40L
#define OSI_ERROR_CONFIG_EXISTS				41L
#define OSI_ERROR_NO_FILTERS                42L
#define OSI_ERROR_READ_FILTERS_FAILED       43L


#define OSI_ERROR_MESSAGE_READ				50L
#define OSI_ERROR_MESSAGE_HEADER_TOO_SHORT	51L
#define OSI_ERROR_MESSAGE_NO_DATA			52L
#define OSI_ERROR_MESSAGE_PAYLOAD_TOO_LARGE	53L
#define OSI_ERROR_MESSAGE_PAYLOAD_TOO_SHORT	54L
#define OSI_ERROR_SETTING_MESSAGE_PAYLOAD	55L
#define OSI_ERROR_SENDING_MESSAGE			56L
#define OSI_ERROR_UNKNOWN_MESSAGE_TYPE		57L

#define OSI_ERROR_DB_INIT_FAILED			60L
#define OSI_ERROR_DB_CREATE_FAILED			61L
#define OSI_ERROR_DB_OPEN_FAILED			62L
#define OSI_ERROR_DB_NOT_OPENED				63L
#define OSI_ERROR_DB_STORING				64L
#define OSI_ERROR_DB_PATH				    65L
#define OSI_ERROR_DB_RETRIEVING				66L
#define OSI_ERROR_DB_DATA_TOO_LARGE			67L
#define OSI_ERROR_DB_INVALID_CURSOR			68L
#define OSI_ERROR_DB_LAST_ITEM				69L
#define OSI_ERROR_DB_ITEM_EXISTS			70L
#define OSI_ERROR_DB_NO_ERRORS				71L
#define OSI_ERROR_DB_ITEM_NOT_FOUND         72L
#define OSI_ERROR_DB_NO_FILTERS             73L
#define OSI_ERROR_BASE_DB_NOT_FOUND         74L

#define OSI_ERROR_FILE_NOT_FOUND			80L
#define OSI_ERROR_PATH_NOT_FOUND			81L
#define OSI_ERROR_ACCESS_DENIED           	82L
#define OSI_ERROR_WRITE_PROTECTED          	83L
#define OSI_ERROR_SHARING_VIOLATION        	84L
#define OSI_ERROR_DIRECTORY_NOT_EMPTY      	85L
#define OSI_ERROR_DISK_FULL                	86L
#define OSI_ERROR_INVALID_PATH             	87L
#define OSI_ERROR_IO_ERROR                	88L
#define OSI_ERROR_FILE_EXISTS             	89L
#define OSI_ERROR_UNABLE_TO_CREATE_FILE		90L

#define OSI_ERROR_UNABLE_TO_OPEN_DIRECTORY	100L
#define OSI_ERROR_UNABLE_TO_STAT_FILE		101L
#define OSI_ERROR_UNABLE_TO_READ_FILE		102L
#define OSI_ERROR_UNABLE_TO_WRITE_FILE  	103L
#define OSI_ERROR_UNABLE_TO_CSUM_FILE       104L

#define OSI_ERROR_UNABLE_TO_CREATE_PROCESS	110L

#define OSI_ERROR_SCANNER_WAS_KILLED		121L
#define OSI_ERROR_SCANNER_WAS_STOPPED		122L

#define OSI_ERROR_SESSION_KEY_NEGOTIATION_FAILED	130L

#define OSI_ERROR_NO_USER_LOGIN_SPECIFIED           140L
#define OSI_ERROR_SET_USER_LOGIN_FAILED             141L
#define OSI_ERROR_READ_USERS_FAILED                 142L
#define OSI_ERROR_NO_USERS                          143L
#define OSI_ERROR_USER_DOES_NOT_EXIST               144L
#define OSI_ERROR_DELETE_USER_FAILED                145L


typedef struct OSI_ERROR
{
    osi_uint64 type;
    osi_uint64 time;

    char message[MAX_ERROR_MESSAGE_LENGTH];

} OSI_ERROR;


/* used for quick return of string message based upon error code. */

struct e_keywords
{
    char *word;
    int  type;
};

extern struct e_keywords error_keywords[];


char * osi_get_name_for_error( osi_uint64 error );

void wrap_error( OSI_ERROR *error );
void unwrap_error( OSI_ERROR *error );

void print_osi_error( OSI_ERROR *error );

void pack_error( OSI_ERROR *error, char *buffer, int buffer_size );
void unpack_error( OSI_ERROR *error, char *buffer, int buffer_size );

#endif

