
/*****************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
*****************************************************************************/

/*****************************************************************************
**
**  File:    host_config.h
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**  Purpose: common host configuration module to read and parse host
**           configuration from a flat file.
**
******************************************************************************/

#ifndef HOST_CONFIG_H_
#define HOST_CONFIG_H_

#define MAX_HOST_CONFIG_LINE_LENGTH	       512
#define MAX_HOST_CONFIG_KEY_LENGTH	       256
#define MAX_HOST_NOTIFY_EMAIL_LENGTH       128

#define HOST_CONFIG_KEY_VALUE_SEPARATOR   '='
#define HOST_CONFIG_COMMENT_LINE	      '#'


#define HOST_CONFIG_KEYWORD_COMMENT	        -1
#define HOST_CONFIG_KEYWORD_UNKNOWN   	     0
#define HOST_CONFIG_KEYWORD_HOSTNAME	     1
#define HOST_CONFIG_KEYWORD_DESCRIPTION      2
#define HOST_CONFIG_KEYWORD_TYPE	         3
#define HOST_CONFIG_KEYWORD_ENABLED	         4
#define HOST_CONFIG_KEYWORD_SESSION_KEY      5
#define HOST_CONFIG_KEYWORD_BASE_DB          6
#define HOST_CONFIG_KEYWORD_FILE_LOG         7
#define HOST_CONFIG_KEYWORD_SCHEDULE_START   8
#define HOST_CONFIG_KEYWORD_SCHEDULE_PERIOD  9
#define HOST_CONFIG_KEYWORD_NOTIFY_ENABLED  10
#define HOST_CONFIG_KEYWORD_NOTIFY_FLAGS    11
#define HOST_CONFIG_KEYWORD_DB_FLAGS        12
#define HOST_CONFIG_KEYWORD_NOTIFY_EMAIL    13
#define HOST_CONFIG_KEYWORD_PORT            14
#define HOST_CONFIG_KEYWORD_CONFIG          15


#define HOST_CONFIG_PERMISSIONS		      0600


/* these are the types of hosts we can talk to, this type */
/* will signify how to conduct communication.             */

#define OSI_HOST_TYPE_GENERIC		0x01
#define OSI_HOST_TYPE_ROUTER		0x02

#define OSI_HOST_TYPE_NAME_UNKNOWN	"unknown"
#define OSI_HOST_TYPE_NAME_GENERIC	"generic"
#define OSI_HOST_TYPE_NAME_ROUTER	"router"

#define OSI_NOTIFY_SCAN_FAILED      0x01
#define OSI_NOTIFY_SCAN_ALWAYS      0x02
#define OSI_NOTIFY_AGENT_REKEY      0x04

#define OSI_DB_ARCHIVE				0x01
#define OSI_DB_PURGE				0x02
#define OSI_DB_AUTOACCEPT			0x04


/* structure used to hold host config data that has been parsed */

typedef struct host_config
{
    char hostname[MAX_HOSTNAME_LENGTH];
    char description[MAX_HOST_BRIEF_DESCRIPTION_LENGTH];
    char session_key[HOST_SESSION_KEY_LENGTH];
    char base_db[MAX_HOSTNAME_LENGTH];
    char notify_email[MAX_HOST_NOTIFY_EMAIL_LENGTH];
    char config[MAX_HOST_BRIEF_CONFIG_LENGTH];

    int type;
    int enabled;

    int file_log_enabled;
    int db_flags;

    int notify_enabled;
    int notify_flags;
    int port;

    unsigned long schedule_start;
    unsigned long schedule_period;
    
    string_list *data;

} OSI_HOST_CONFIG;


struct h_keywords
{
    char *word;
    int  type;
};


/* function prototypes. */

OSI_HOST_CONFIG * osi_host_config_new();
void osi_host_config_destroy( OSI_HOST_CONFIG *config );

OSI_HOST_CONFIG * osi_host_config_new_from_file( const char *filepath );

osi_bool osi_host_config_receive_first( OSI_HOST_CONFIG *config,
                                        unsigned char *data, int data_length );

osi_bool osi_host_config_receive( OSI_HOST_CONFIG *config,
                                  unsigned char *data, int data_length );

osi_bool osi_host_config_receive_last( OSI_HOST_CONFIG *config,
                                       unsigned char *data, int data_length );

osi_bool osi_host_config_read_file( const char *filepath,
                                    OSI_HOST_CONFIG *config );

osi_bool osi_host_config_write_file( const char *root_path,
                                     OSI_HOST_CONFIG *config );

osi_bool osi_host_brief_read_file( const char *filepath,
                                   OSI_HOST_BRIEF *host_brief );

osi_bool osi_host_brief_write_file( const char *filepath,
                                    OSI_HOST_BRIEF *host_brief );

osi_bool osi_host_config_update_data( OSI_HOST_CONFIG *config );
char *get_name_from_host_type( int type );

/* utility functions to parse the config file. */

osi_bool parse_host_config_line( char *line, OSI_HOST_CONFIG *config );
osi_bool parse_host_brief_line( char *line, OSI_HOST_BRIEF *host_brief );

int get_host_config_line_type( char *string );

osi_bool get_host_config_line_value( char *line, char *value, int value_size );
osi_bool translate_boolean_value( char *keyword );

#endif

