
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    logging.h
**  Date:    February 17, 2002
**  
**  Author:  Brian Wotring
**  Purpose: logging routines.
**
******************************************************************************/

#ifndef LOGGING_H_
#define LOGGING_H_


#ifndef WIN32
#define SYSLOG_OPTIONS	        ( LOG_NDELAY | LOG_PID )
#endif

#define OSI_LOG_DEFAULT_PERMS   0600
#define MAX_LOG_MESSAGE_LENGTH  1024

/* log ID codes. */

#define LOG_ID_GENERIC_INFO         10
#define LOG_ID_GENERIC_ERROR        11
#define LOG_ID_GENERIC_FILE_ERROR   12
#define LOG_ID_DAEMON_INFO          13
#define LOG_ID_DAEMON_ERROR         14
#define LOG_ID_DAEMON_UNAUTHORIZED  15
#define LOG_ID_DAEMON_AUTHORIZED    16
#define LOG_ID_DAEMON_CRITICAL      17
#define LOG_ID_CERT_MISMATCH        18

#define LOG_ID_AUTH_ERROR           100
#define LOG_ID_AUTH_LOGIN_SUCCESS   101
#define LOG_ID_AUTH_LOGIN_FAILURE   102
#define LOG_ID_AUTH_WARNING         103
#define LOG_ID_AUTH_SAVE_SUCCESS    104
#define LOG_ID_AUTH_SAVE_FAILURE    105
#define LOG_ID_AUTH_DB_RELOAD       106


#define LOG_ID_CMP_BEGIN            200
#define LOG_ID_CMP_END              201
#define LOG_ID_CMP_FILE_MISSING     202
#define LOG_ID_CMP_FILE_NEW         203
#define LOG_ID_CMP_CHECKSUM         204
#define LOG_ID_CMP_DEVICE           205
#define LOG_ID_CMP_INODE            206
#define LOG_ID_CMP_PERM             207
#define LOG_ID_CMP_SYMLINKS         208
#define LOG_ID_CMP_UID              209
#define LOG_ID_CMP_GID              210
#define LOG_ID_CMP_MTIME            211
#define LOG_ID_CMP_ATIME            212
#define LOG_ID_CMP_CTIME            213
#define LOG_ID_CMP_DEVICETYPE       214
#define LOG_ID_CMP_BYTES            215
#define LOG_ID_CMP_BLOCKS           216
#define LOG_ID_CMP_BLOCKSIZE        217
#define LOG_ID_CMP_OWNER_SID        218
#define LOG_ID_CMP_GROUP_SID        219
#define LOG_ID_CMP_WIN_FILE_ATTR    220
#define LOG_ID_CMP_GENERIC_NEW      221
#define LOG_ID_CMP_GENERIC_MISSING  222
#define LOG_ID_CMP_GENERIC_DIFF     223

#define LOG_ID_DB_OPEN_ERROR        300
#define LOG_ID_DB_STORE_ERROR       301
#define LOG_ID_DB_TRUSTED_SET       302
#define LOG_ID_DB_CREATE_ERROR      303
#define LOG_ID_DB_AUTOACCEPT_ERROR	304
#define LOG_ID_DB_AUTOACCEPT        305

#define LOG_ID_PEER_MSG             400
#define LOG_ID_PEER_CLOSE           401
#define LOG_ID_PEER_INVALID_MSG     402
#define LOG_ID_PEER_READ_FAILURE    403
#define LOG_ID_PEER_WRITE_FAILURE   404

#define LOG_ID_SCAN_BEGIN           500
#define LOG_ID_SCAN_END             501
#define LOG_ID_SCAN_ABORT           502
#define LOG_ID_SCAN_ERROR           503
#define LOG_ID_SCAN_SPAWN           504

#define LOG_ID_SESSION_KEY_FAILURE  600
#define LOG_ID_SESSION_KEY_VALID    601
#define LOG_ID_SESSION_KEY_UPDATE   602
#define LOG_ID_SESSION_KEY_INVALID  603
#define LOG_ID_SESSION_KEY_LOST     604
#define LOG_ID_SESSION_KEY_MISSING  605
#define LOG_ID_SESSION_KEY_NEW      606

#define LOG_ID_HTTP_ERROR           700
#define LOG_ID_HTTP_RECEIVE         701
#define LOG_ID_NOTIFY_ERROR         702
#define LOG_ID_NOTIFY_INFO          703

#define LOG_ID_SCHEDULER_RELOAD     800
#define LOG_ID_SCHEDULER_START      801
#define LOG_ID_SCHEDULER_STOP       802
#define LOG_ID_SCHEDULER_FAIL       803
#define LOG_ID_SCHEDULER_INFO       804

#define LOG_ID_LOG_APP_FAILURE      900


void log_error( int id, const char *host, const char *message, ... );
void log_info( int id, const char *host, const char *message, ... );
void log_warning( int id, const char *host, const char *message, ... );

int log_cmp_message( int id, OSI_DB_CTX *context, const char *message, ... );

osi_bool log_payload_is_filtered( const char *payload );

#endif
