
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_log.h
**  Date:    June 3, 2002
**
**  Author:  Brian Wotring
**  Purpose: interact with local file system to read in log information
**           from hosts directory.
**
******************************************************************************/

#ifndef MD_LOG_H_
#define MD_LOG_H_

#define MAX_LOG_NAME_LENGTH 15
#define MAX_LOG_FILE_LINE_LENGTH 512

int osi_host_read_log_briefs( OSI_HOST *host );

OSI_LOG_BRIEF * osi_host_read_log_brief_with_name( const char *host,
                                                   const char *name );

string_list * osi_host_get_log_data( const char *host,
                                     const char *name );

void generate_log_file_name( const char *host, char *path, int path_size );


#endif

