
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    socketapi.h
**  Date:    February 17, 2002
**
**  Author:  Brian Wotring
**  Purpose: network wrappers and routines.
**
******************************************************************************/

#ifndef SOCKETAPI_H_
#define SOCKETAPI_H_



/* socket wrapper functions. */

int osi_socket( unsigned int family, unsigned int type, unsigned int protocol );

int osi_accept( unsigned int socket, struct sockaddr *remote_address,
                socklen_t *addressLength );

int osi_bind( unsigned int socket, struct  sockaddr *local_address,
              socklen_t sockaddrLength );

int osi_listen( unsigned int socket, unsigned int max_waiting );

void osi_close_socket( unsigned int socket );
void osi_shutdown_ssl( SSL *ssl );

int osi_read( unsigned int read_socket, char *buffer,
              unsigned int buffer_size );

int osi_write( unsigned int send_socket, const char *buffer,
               unsigned int buffer_size );

int osi_read_bytes( unsigned int read_socket, char *buffer,
                    unsigned int buffer_size, int bytes_to_read );

int osi_write_bytes( unsigned int write_socket, const char *buffer,
                     unsigned int bytes_to_write );

/* SSL socket wrapper functions. */

SSL * osi_ssl_accept( unsigned int server_socket, 
                      struct sockaddr *remote_address, 
                      socklen_t *address_length, 
                      SSL_CTX *ctx, 
                      osi_bool initiate );

SSL * osi_ssl_accept_with_socket( unsigned int client_socket, SSL_CTX *ctx, 
                                  osi_bool initiate );
                                  
SSL * osi_ssl_connect_to_host_on_port( const char *host, unsigned int port,
                                       SSL_CTX *ctx, osi_bool initiate );

int osi_ssl_read_bytes( SSL *ssl, char *buffer, unsigned int buffer_size,
                        int bytes_to_read );

int osi_ssl_write_bytes( SSL *ssl, const char *buffer,
                         unsigned int bytes_to_write );

int osi_ssl_read( SSL *ssl, char *buffer, unsigned int buffer_size );
int osi_ssl_write( SSL *ssl, const char *buffer, unsigned int buffer_size );

void osi_ssl_destroy( SSL **ssl );

/* useful client/server functions. */

int osi_connect( unsigned int  socket,  struct sockaddr *local_address,
                 socklen_t address_length );

int osi_connect_to_host_on_port( const char *host, unsigned int port );
int osi_listen_on_local_port( unsigned int port, unsigned int server_limit );

int osi_data_available( unsigned int read_socket );

int osi_set_socket_blocking( int connection_socket );
int osi_set_socket_non_blocking( int connection_socket );

#ifndef HAVE_INET_PTON
int inet_pton( int family, const char *name, void *address );
#endif

#ifndef HAVE_INET_NTOP
const char * inet_ntop( int family, const void *address, char *name,
                        size_t length );
#endif

#ifndef HAVE_SOCKETPAIR
int socketpair( int family, int type, int protocol, int *fd );
#endif


#endif  /* ifndef SOCKETAPI_H */


