
;NSIS Modern User Interface version 1.64
;Osiris Installation Script
;Written by Brian Wotring


!include "MUI.nsh"

Name "Osiris Host Integrity Monitoring System - version 4.2.2-release"

;--------------------------------
;Configuration

  ;General

  OutFile "osiris_install.exe"

  ;Show installer the commands used to install files.

  ShowInstDetails show
  XPStyle on

;--------------------------------
; Pages

  !insertmacro MUI_PAGE_LICENSE "..\..\..\LICENSE" 
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_INSTFILES

;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"
  
;--------------------------------
;Language Strings

  ;Descriptions

  LangString DESC_Osiris ${LANG_ENGLISH} "Osiris comand line utility.  Use this application to communicate with an osiris management host."

  LangString DESC_Osirisd ${LANG_ENGLISH} "Osiris client service.  This is the service used to periodically scan the local filesystem.  Install this on any host you wish to scan."

  LangString DESC_Osirismd ${LANG_ENGLISH} "Osiris management service used to manage a network of scanned hosts.  This service should only be installed on a secure and trusted machine."

  CompletedText "Installation Complete. See http://www.hostintegrity.com/osiris for complete documentation." 

;--------------------------------
;License Data
  
  LicenseData "..\..\..\LICENSE"
  LicenseBkColor ffffff

;--------------------------------
;Installer Sections

Section "Osiris CLI" SecCopyOsiris

; this is for the command line options, if we see the cli option, install
; it, otherwise, skip it.  We only care about this if we are in silent mode.

IfSilent 0 begin_cli

Push $CMDLINE 
Push "cli"
Call StrStr
Pop $R0

    StrCmp $R0 "" 0 +2
goto end_cli

begin_cli:

  SetOutPath "$WINDIR"
  File "..\..\cli\osiris.exe"

  ;Create uninstaller
  WriteUninstaller "$WINDIR\osiris\uninstall_osiris.exe"

end_cli:

SectionEnd

Section "Scanning Service" SecCopyOsirisd

IfSilent 0 begin_osirisd

Push $CMDLINE
Push "osirisd"
Call StrStr
Pop $R0

    StrCmp $R0 "" 0 +2
goto end_osirisd

begin_osirisd:

  SetOutPath "$SYSDIR"

  ; first install the service installer in temp.
  ; and stop/uninstall any existing service.

  File "service_installer\service_installer.exe"
  ExecWait "$SYSDIR\service_installer.exe osirisd"
  DetailPrint "Waiting 30 seconds for any existing agent to shut down..."
  Sleep 30000

  ; now create the osiris directory.

  CreateDirectory "$WINDIR\osiris"

  ; now install the servivce file.

  File "..\..\osirisd\osirisd.exe"

  ; install root certificate if it is there.

  SetOutPath "$WINDIR\osiris"
  File "..\*.pem"
  Delete "$WINDIR\osiris\empty.pem"
  SetOutPath "$SYSDIR"

  ; now install and start the service.

  ExecWait "$SYSDIR\service_installer.exe osirisd Osiris_IDS_Scanner $SYSDIR\osirisd.exe"

  ; delete the service installer.

  Delete "$SYSDIR\service_installer.exe"

  ; now create the reg keys for event viewer madness.

  WriteRegDWORD HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirisd" "MaxSize" 524288
  WriteRegDWORD HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirisd" "CategoryCount" 1
  WriteRegDWORD HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirisd" "TypesSupported" 7
  WriteRegExpandStr HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirisd" "CategoryMessageFile" "%SystemRoot%\system32\osimessage.dll"
  WriteRegExpandStr HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirisd" "EventMessageFile" "%SystemRoot%\system32\osimessage.dll"
  WriteRegExpandStr HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirisd" "File" "%SystemRoot%\system32\config\Logger.evt"

  File "osimessage.dll"

  ;Create uninstaller
  WriteUninstaller "$WINDIR\osiris\uninstall_osiris.exe"

end_osirisd:

SectionEnd

Section "Management Service" SecCopyOsirismd

IfSilent 0 begin_osirismd

Push $CMDLINE
Push "osirismd"
Call StrStr
Pop $R0

    StrCmp $R0 "" 0 +2
goto end_osirismd

begin_osirismd:

  SetOutPath "$SYSDIR"

  ; first install the service installer in temp.
  ; and stop/uninstall any existing service.

  File "service_installer\service_installer.exe"
  ExecWait "$SYSDIR\service_installer.exe osirismd"
  DetailPrint "Waiting 30 seconds for any existing console to shut down..."
  Sleep 30000

  ; now create the osiris directory.

  CreateDirectory "$WINDIR\osiris"

  ; now install the servivce file.

  File "..\..\osirismd\osirismd.exe"

  ; now install and start the service.

  ExecWait "$SYSDIR\service_installer.exe osirismd Osiris_IDS_Management $SYSDIR\osirismd.exe"

  File "osimessage.dll"

  ; now install default configs.

  SetOutPath "$WINDIR\osiris\configs"
  File "..\..\configs\default.*"

  ; delete the service installer.

  Delete "$SYSDIR\service_installer.exe"

  ; now create the reg keys for event viewer madness.

  WriteRegDWORD HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirismd" "CategoryCount" 1
  WriteRegDWORD HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirismd" "TypesSupported" 7
  WriteRegExpandStr HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirismd" "CategoryMessageFile" "%SystemRoot%\system32\osimessage.dll"
  WriteRegExpandStr HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirismd" "EventMessageFile" "%SystemRoot%\system32\osimessage.dll"
  WriteRegExpandStr HKLM "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\osirismd" "File" "%SystemRoot%\system32\config\Logger.evt"

  ;Create uninstaller
  WriteUninstaller "$WINDIR\osiris\uninstall_osiris.exe"

end_osirismd: 
SectionEnd

;--------------------------------
;Show Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyOsiris} $(DESC_Osiris)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyOsirisd} $(DESC_Osirisd)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyOsirismd} $(DESC_Osirismd)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; remove registry settings.

  DeleteRegKey HKLM  "SYSTEM\CurrentControlSet\Services\Eventlog\Application\osirismd"

  DeleteRegKey HKLM  "SYSTEM\CurrentControlSet\Services\Eventlog\Application\osirisd"

  Delete "$WINDIR\osiris.exe"
  Delete "$WINDIR\osirisd.exe"
  Delete "$WINDIR\osirismd.exe"

  Delete "$WINDIR\osiris\uninstall_osiris.exe"

  RMDir /r "$WINDIR\osiris"

SectionEnd


 ; StrStr
 ; input, top of stack = string to search for
 ;        top of stack-1 = string to search in
 ; output, top of stack (replaces with the portion of the string remaining)
 ; modifies no other variables.
 ;
 ; Usage:
 ;   Push "this is a long ass string"
 ;   Push "ass"
 ;   Call StrStr
 ;   Pop $R0
 ;  ($R0 at this point is "ass string")

 Function StrStr
 Exch $R1 ; st=haystack,old$R1, $R1=needle
   Exch    ; st=old$R1,haystack
   Exch $R2 ; st=old$R1,old$R2, $R2=haystack
   Push $R3
   Push $R4
   Push $R5
   StrLen $R3 $R1
   StrCpy $R4 0
   ; $R1=needle
   ; $R2=haystack
   ; $R3=len(needle)
   ; $R4=cnt
   ; $R5=tmp
   loop:
     StrCpy $R5 $R2 $R3 $R4
     StrCmp $R5 $R1 done
     StrCmp $R5 "" done
     IntOp $R4 $R4 + 1
     Goto loop
 done:
   StrCpy $R1 $R2 "" $R4
   Pop $R5
   Pop $R4
   Pop $R3
   Pop $R2
   Exch $R1
 FunctionEnd

