#include "pangui.h"

/* external functions */
int  OpenPasswordNDS(int path_provided, char *ret_path);
int  OpenRestoreNDS(int path_provided, char *ret_path);
void DumpValueData(Pan_NDSBrowse q, char *path, char *ext);

/* internal functions */
int  ShowPasswordList(int type);

/*** Screen output of password lists and records ***/
/***************************************************/

/*** Sort sub-routines ****/
int cmp_PassList_name (Pan_PassList *a,Pan_PassList *b)
{
 char temp[128], temp2[128];
 sprintUnicodeName(temp,(*a)->userCN,126);
 sprintUnicodeName(temp2,(*b)->userCN,126);
 return strcmp(temp,temp2);
}
int cmp_PassList_context (Pan_PassList *a,Pan_PassList *b)
{
 char temp[21], temp2[21];
 sprintUnicodeName(temp,(*a)->userOU,20);
 sprintUnicodeName(temp2,(*b)->userOU,20);
 return strcmp(temp,temp2);
}
int cmp_PassList_bindery (Pan_PassList *a,Pan_PassList *b)
{
 return ( ((*a)->bind==(*b)->bind)?0:
          (((*a)->bind>(*b)->bind)?1:-1)
        );
}
int cmp_PassList_pwlen (Pan_PassList *a,Pan_PassList *b)
{
 return ( ((*a)->pwlen==(*b)->pwlen)?0:
          (((*a)->pwlen>(*b)->pwlen)?1:-1)
        );
}
int cmp_PassList_ID (Pan_PassList *a,Pan_PassList *b)
{
 return ( ((*a)->objectID==(*b)->objectID)?0:
          (((*a)->objectID>(*b)->objectID)?1:-1)
        );
}
int cmp_PassList_hash (Pan_PassList *a,Pan_PassList *b)
{
 int i;
 for (i=0;i<16;i++)
  {
   if ( (*a)->hash[i] < (*b)->hash[i] ) return -1;
   if ( (*a)->hash[i] > (*b)->hash[i] ) return 1;
  }
 return 0;
}
int cmp_NDSBrowse_objectID (Pan_NDSBrowse *a,Pan_NDSBrowse *b)
{
 return ( ((*a)->objectID==(*b)->objectID)?0:
          (((*a)->objectID>(*b)->objectID)?1:-1)
        );
}
int cmp_NDSBrowse_objectStr (Pan_NDSBrowse *a,Pan_NDSBrowse *b)
{
 return (strcmp((*a)->objectStr,(*b)->objectStr));
}
int cmp_NDSBrowse_parentID (Pan_NDSBrowse *a,Pan_NDSBrowse *b)
{
 return ( ((*a)->parentID==(*b)->parentID)?0:
          (((*a)->parentID>(*b)->parentID)?1:-1)
        );
}
int cmp_NDSBrowse_parentStr (Pan_NDSBrowse *a,Pan_NDSBrowse *b)
{
 return (strcmp((*a)->parentStr,(*b)->parentStr));
}
int cmp_NDSBrowse_typeID (Pan_NDSBrowse *a,Pan_NDSBrowse *b)
{
 return ( ((*a)->typeID==(*b)->typeID)?0:
          (((*a)->typeID>(*b)->typeID)?1:-1)
        );
}
int cmp_NDSBrowse_typeStr (Pan_NDSBrowse *a,Pan_NDSBrowse *b)
{
 return (strcmp((*a)->typeStr,(*b)->typeStr));
}
void sort_PassList_name(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index,nIndex,sizeof(Pan_PassList),(int (*)(const void *,const void *))cmp_PassList_name);
   ShowPasswordList(1);}
void sort_PassList_context(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index,nIndex,sizeof(Pan_PassList),(int (*)(const void *,const void *))cmp_PassList_context);
   ShowPasswordList(1);}
void sort_PassList_bindery(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index,nIndex,sizeof(Pan_PassList),(int (*)(const void *,const void *))cmp_PassList_bindery);
   ShowPasswordList(1);}
void sort_PassList_pwlen(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index,nIndex,sizeof(Pan_PassList),(int (*)(const void *,const void *))cmp_PassList_pwlen);
   ShowPasswordList(1);}
void sort_PassList_ID(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index,nIndex,sizeof(Pan_PassList),(int (*)(const void *,const void *))cmp_PassList_ID);
   ShowPasswordList(1);}
void sort_PassList_hash(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index,nIndex,sizeof(Pan_PassList),(int (*)(const void *,const void *))cmp_PassList_hash);
   ShowPasswordList(1);}
void sort_NDSBrowse_objectID(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index2,nIndex,sizeof(Pan_NDSBrowse),(int (*)(const void *,const void *))cmp_NDSBrowse_objectID);
   ShowPasswordList(3);}
void sort_NDSBrowse_parentID(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index2,nIndex,sizeof(Pan_NDSBrowse),(int (*)(const void *,const void *))cmp_NDSBrowse_parentID);
   ShowPasswordList(3);}
void sort_NDSBrowse_typeID(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index2,nIndex,sizeof(Pan_NDSBrowse),(int (*)(const void *,const void *))cmp_NDSBrowse_typeID);
   ShowPasswordList(3);}
void sort_NDSBrowse_objectStr(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index2,nIndex,sizeof(Pan_NDSBrowse),(int (*)(const void *,const void *))cmp_NDSBrowse_objectStr);
   ShowPasswordList(3);}
void sort_NDSBrowse_parentStr(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index2,nIndex,sizeof(Pan_NDSBrowse),(int (*)(const void *,const void *))cmp_NDSBrowse_parentStr);
   ShowPasswordList(3);}
void sort_NDSBrowse_typeStr(MOBJECT o, void *item, void *a_data)
  {qsort((void *)Index2,nIndex,sizeof(Pan_NDSBrowse),(int (*)(const void *,const void *))cmp_NDSBrowse_typeStr);
   ShowPasswordList(3);}

/* When you double click on an item from the list... */
void SelectOpenPassword(MOBJECT p, LIST_ACT *la, void *v)
{
 Pan_PassList q;
 char str[512],user[129],context[41],hash[33];
 int i;

 /* race condition prevent */
 while (!(_smutex_available(&attacking)));
 _smutex_request(&attacking);

 q=Index[(long)la->u_data];

 if (!q)
   {
    MMessageDialog("", "An error occured :\nCanno't access element", "Ok", NULL);
    _smutex_release(&attacking);
    return;
   }
 Pan_PassList_to_PassHack(q,&pPassHack); /* save information */

 pPassHack.pw_first[0]='\0';
 pPassHack.pw_current[0]='\0';
 pPassHack.pw_last[0]='\0'; /* NULL values are checked in Pandora API*/
 pPassHack.key_space[0]='\0';

 /* show selected target */
 sprintUnicodeName(user,q->userCN,128);
 sprintUnicodeName(context,q->userOU,40);
 for (i=0;i<16;i++) sprintf(hash+i*2,"%02x",q->hash[i]);
 sprintf(str, "Selected target is\n\n User: %s\nContext: %s\nBindery type: %04lx\nObjectID: %08lx\nPassword lengh: %03d\nHash: %s\n",
         user,context,q->bind,q->objectID,(int)q->pwlen,hash);
 MMessageDialog("", str, "Ok", NULL);
 strcpy(str,user); strcat(str,"."); strcat(str,context);
 MEditChangeText(edit_00, 0, 168, str, 65);

 _smutex_release(&attacking);
}

void SelectOpenRestore(MOBJECT p, LIST_ACT *la, void *v)
{
 Pan_PassList q;
 char str[512],user[129],context[41],hash[33];
 int i;

 /* Update selected target field only if no attack is undergo */
 /* race condition prevent */
 while (!(_smutex_available(&attacking)));
 _smutex_request(&attacking);

 q=Index[(long)la->u_data];

 if (!q)
   {
    MMessageDialog("", "An error occured :\nCanno't access element", "Ok", NULL);
    _smutex_release(&attacking);
    return;
   }
 /* TODO : REREAD FROM FILE, FOR CLUSTERFUK */
 /*Pan_PassList_to_PassHack(q,&pPassHack);  save information */

 /* show selected target */
 sprintUnicodeName(user,q->userCN,128);
 sprintUnicodeName(context,q->userOU,40);
 for (i=0;i<16;i++) sprintf(hash+i*2,"%02x",q->hash[i]);
 sprintf(str, "Selected target is\n\n User: %s\nContext: %s\nBindery type: %04lx\nObjectID: %08lx\nPassword lengh: %03d\nHash: %s\n",
         user,context,q->bind,q->objectID,(int)q->pwlen,hash);
 MMessageDialog("", str, "Ok", NULL);
 strcpy(str,user); strcat(str,"."); strcat(str,context);
 MEditChangeText(edit_00, 0, 168, str, 65);

 _smutex_release(&attacking);
}

void SelectOpenValue(MOBJECT p, LIST_ACT *la, void *v)
{
 Pan_NDSBrowse q;

 /* race condition prevent */
 while (!(_smutex_available(&attacking)));
 _smutex_request(&attacking);

 q=Index2[(long)la->u_data];

 if (!q)
   {
    MMessageDialog("", "An error occured :\nCanno't access element", "Ok", NULL);
    _smutex_release(&attacking);
    return;
   }

 _smutex_release(&attacking);

 DumpValueData(q,ret_path,ext);
}

/**************************************************
*	This callback is called by the Object when
*	it needs data for drawing rows in the
*	virtual list. The application must 'sprintf'
*	row data in the linked list passed by the
*	Object
**************************************************/
void BuildLineFromPassList(Pan_PassList q,char *str)
{
 char temp[512];
 int i;

 strcpy(str,"\0");
 sprintUnicodeName(temp,q->userCN,14);
 strcat(str,temp+3);
 for (i=0;i<11;i++) if (str[i]=='\0')
                                   {
                                    for (;i<11;i++) str[i]=' ';
                                    str[i]='\0';
                                    break;
                                   }
 sprintUnicodeName(temp,q->userOU,11);
 strcat(str," ");
 if (temp[0]) strcat(str,strchr(temp,'=')+1); /*Supervisor has no OU*/
 for (i=12;i<20;i++) if (str[i]=='\0')
                                    {
                                     for (;i<20;i++) str[i]=' ';
                                     str[i]='\0';
                                     break;
                                    }
 sprintf(temp," %04lx",q->bind);
 strcat(str,temp);
 sprintf(temp," %08lx",q->objectID);
 strcat(str,temp);

 if(q->pwlen_known)
  {
   sprintf(temp," %03d ",(int)q->pwlen);
   strcat(str,temp);
  }
 else strcat(str," *** ");

 if ((q->password[0]=='\0')&&(q->pwlen==0)&&(q->pwlen_known))
  strcat(str,"      null");
 else strncat(str,q->password,16);
 for (i=38;i<55;i++) if (str[i]=='\0')
                      {
                       for (;i<55;i++) str[i]=' ';
                       str[i]='\0';
                       break;
                      }

 if(q->pwhash_known)
  for (i=0;i<16;i++)
   {
    sprintf(temp,"%02x",q->hash[i]);
    strcat(str,temp);
   }
 else strcat(str,"********************************");
}

void BuildLineFromNDSBrowse(Pan_NDSBrowse q,char *str)
{
 char temp[512];
 int i;

 strcpy(str,q->objectStr);    /* I have NO FUCKING idea why when i use
                                 strncpy here it seg'faults */
 str[20]='\0';
 for (i=0;i<20;i++) if (str[i]=='\0')
                                   {
                                    for (;i<20;i++) str[i]=' ';
                                    str[i]='\0';
                                    break;
                                   }
 strcat(str,q->parentStr);
 for (i=20;i<40;i++) if (str[i]=='\0')
                                   {
                                    for (;i<40;i++) str[i]=' ';
                                    str[i]='\0';
                                    break;
                                   }
 strcat(str,q->typeStr);
 for (i=40;i<60;i++) if (str[i]=='\0')
                                   {
                                    for (;i<60;i++) str[i]=' ';
                                    str[i]='\0';
                                    break;
                                   }
 sprintf(temp," %08lx %08lx %08lx ",q->objectID,q->parentID,q->typeID);
 strcat(str,temp);
}

void BuildLineFromConnections(Pan_Connections q,char *str)
{
 char temp[512];
 int i;

 strcpy(str,q->name);
 str[18]='\0';
 for (i=0;i<18;i++) if (str[i]=='\0')
                                   {
                                    for (;i<18;i++) str[i]=' ';
                                    str[i]='\0';
                                    break;
                                   }

 if (q->conn_type==PAN_TYPE_SERVER) strcat(str,"Srv ");
 if (q->conn_type==PAN_TYPE_USER)   strcat(str,"Usr ");
 if (q->conn_type==PAN_TYPE_OTHER)  strcat(str,"Auth");
 strcat(str," ");

 if (q->conn_number)
  sprintf(temp,"%03d",q->conn_number);
 else strcpy(temp,"***");
 strcat(str,temp);
 strcat(str,"  ");

 if ((!q->ipx_addr[0])&&(!q->ipx_addr[1])&&(!q->ipx_addr[2])
     &&(!q->ipx_addr[3])&&(!q->ipx_addr[4])&&(!q->ipx_addr[5]))
  {
   for (i=0;i<4;i++)
    {
     sprintf(temp,"%03d",q->ipx_net[i]);
     strcat(str,temp);
     if (i!=3) strcat(str,".");
    }
   strcat(str," ");
  }
 else
  {
   for (i=0;i<4;i++)
    {
     sprintf(temp,"%02x",q->ipx_net[i]);
     strcat(str,temp);
    }
   strcat(str,"        ");
  }

 for (i=0;i<6;i++)
  {
   sprintf(temp,"%02x",q->ipx_addr[i]);
   strcat(str,temp);
  }
 strcat(str," ");

 sprintf(temp,"%02x",q->sock_high);
 strcat(str,temp);
 strcat(str,"  ");

 sprintf(temp,"%02x",q->sock_low);
 strcat(str,temp);
 strcat(str,"  ");
}

static void NewBlockCB(MOBJECT obj, SBL_NEW_BLOCK * pnb, void *data)
{
 int j;
 long off;
 Pan_PassList q;
 Pan_NDSBrowse r;
 Pan_Connections s;
 char str[512], temp[64];
 XL_ITEM *pd = pnb->pi;

 off = pnb->offset;
 for (j = 0; ( (j < pnb->nr) && pd ) ; j++)
  {
   if (off<nIndex)
    {
     if(pPassList)
      {
       q=Index[off];
       BuildLineFromPassList(q,str);
      }
     if(pNDSBrowse)
      {
       r=Index2[off];
       BuildLineFromNDSBrowse(r,str);
      }
     if(pConnections)
      {
       s=Index3[off];
       BuildLineFromConnections(s,str);
      }
     sprintf(temp, " @%09ld", off);
     strcat(str,temp);

     strcpy(pd->data,str);
     pd->u_data = (void *) off++;
    }
   else /* Although the following items won't be outputed to screen */
    {   /* mgui requires we created them, or the gui crashes */
     sprintf(temp, " @%09ld", off);
     strcpy(pd->data,temp);
     pd->u_data = (void *) off++;
    }
  pd = pd->next;
 }
}

/**************************************************
*	This callback is called by the Object when
*	it needs to know the position (if any) of
*	an item in the list.
**************************************************/
static void NewPosCB(MOBJECT obj, SBL_ITEM_SEEK * pis, void *data)
{
    char *str = pis->sub_item;

    while (*str != '@') str++;

    pis->pos = atol(str);
}

/**************************************************
 *  This callback opens a popup menu when the right
 *  mouse button is pressed within the Object which
 *  this callback is set to.
 *  X and Y positions for this popup are those in the
 *  mouse event.
 **************************************************/
void PopupMenuCB(MOBJECT obj, MEvent * pe, void *pdown)
{
 if (pe->mouse.button == Button3)
  MPopupMenu((MOBJECT) pdown, pe->mouse.x_root, pe->mouse.y_root);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
int ShowPasswordList(int type)
{ /* type 1 :Pan_PassList, 2 :Pan_PassHack, 3:Pan_NDSBrowse 4:Pan_Connections */
  /* type NULL: Don't set callback, list allready exists */

 /*** WARNING : The order in which mouse_menu objects, mouse_menu events and
  slist are created/reinitialized/deleted, was VERY carefully crafted due to
  some (bugs?) problems encountered. I.E : DO NOT attempt to move piece of
  code around in this procedure. */

 if (slist) /** slist exists after first creation and must be reinitialized **/
 {
  MObjectRemoveEventNotifyCallback(slist, PopupMenuCB, mouse_menu);
  MObjectDestroy(mouse_menu);
  MSListReset(slist);
 }
 else
  #ifdef UNIX
  slist=MCreateSListClip(form0, NewBlockCB, 0L, NewPosCB, 0L, FIXED_MEDIUM, 9, 66, 127, nIndex);
  #else
  slist=MCreateSListClip(form0, NewBlockCB, 0L, NewPosCB, 0L, FIXED_MEDIUM, 9, 59, 127, nIndex);
  #endif

 mouse_menu = MCreatePopupMenu(HELV_SMALL);

 if (type==1)
  {
   MSListSetCallback(slist, SelectOpenPassword, (void *) slist);
   MSBLSetHead(slist, "User        Context  Bind ObjectID len Password        Hash                                                                   ");
   MMenuAddItemObsolete(mouse_menu,"by name",sort_PassList_name, slist);
   MMenuAddItemObsolete(mouse_menu,"by context",sort_PassList_context, slist);
   MMenuAddItemObsolete(mouse_menu,"by bind type",sort_PassList_bindery, slist);
   MMenuAddItemObsolete(mouse_menu,"by pass lengh",sort_PassList_pwlen, slist);
   MMenuAddItemObsolete(mouse_menu,"by user ID",sort_PassList_ID, slist);
   MMenuAddItemObsolete(mouse_menu,"by pass hash",sort_PassList_hash, slist);
  }
 if (type==2)
  {
   MSBLSetHead(slist, "User        Context  Bind ObjectID len Password        Hash                                                                   ");
   MMenuAddItemObsolete(mouse_menu,"by name",sort_PassList_name, slist);
   MMenuAddItemObsolete(mouse_menu,"by context",sort_PassList_context, slist);
   MMenuAddItemObsolete(mouse_menu,"by bind type",sort_PassList_bindery, slist);
   MMenuAddItemObsolete(mouse_menu,"by pass lengh",sort_PassList_pwlen, slist);
   MMenuAddItemObsolete(mouse_menu,"by user ID",sort_PassList_ID, slist);
   MMenuAddItemObsolete(mouse_menu,"by pass hash",sort_PassList_hash, slist);
   MSListSetCallback(slist, SelectOpenRestore, (void *) slist);
  }
 if (type==3)
  {
   MSBLSetHead(slist, "Object Name         Parent Name         Attribute Name       ObjectID ParentID AttribID                                        ");
   MMenuAddItemObsolete(mouse_menu,"by object name",sort_NDSBrowse_objectStr, slist);
   MMenuAddItemObsolete(mouse_menu,"by parent name",sort_NDSBrowse_parentStr, slist);
   MMenuAddItemObsolete(mouse_menu,"by attribute name",sort_NDSBrowse_typeStr, slist);
   MMenuAddItemObsolete(mouse_menu,"by object ID",sort_NDSBrowse_objectID, slist);
   MMenuAddItemObsolete(mouse_menu,"by parent ID",sort_NDSBrowse_parentID, slist);
   MMenuAddItemObsolete(mouse_menu,"by attribute ID",sort_NDSBrowse_typeID, slist);
   MSListSetCallback(slist, SelectOpenValue, (void *) slist);
  }
 if (type==4)
  {
   MSBLSetHead(slist, "Name              Type Conn IPX/IP net      IPX Address  s.H s.L                                   ");
  /* nothing yet for mouse right click */
  /* nothing yet for double click */
  }

 MObjectAddEventNotifyCallback(slist, PopupMenuCB, EM_BUTTON_PRESS, mouse_menu);
 MSBLHeadSetColor(slist, seagreen, white);
 MObjectSetPopupHelp(slist, "Right mouse click for sort options\nDouble click to select",500,2000);
 MEditChangeText(edit_00, 0, 168, "", 65);

 return(0);
}

/** Main shell sub-routines **/
/*****************************/

/* Stop current thread */
void StopProcess(MOBJECT p, LIST_ACT *la, void *v)
{
 LIST_ACT *lb;

 if (la->u_data==NULL)
  {
   if (MMessageDialog("", "Erase ?", "Yes", "No", NULL))
    return;
   /* race condition */
   while (!(_smutex_available(&attacking)));
   _smutex_request(&attacking);

   lb=MSListGetElement(rlist,la->pos+1);
   while(lb!=NULL)
    {
     if (lb->u_data!=NULL)
      {
       if (*((int*)(lb->u_data))>0)
        *((int*)(lb->u_data))=(*((int*)(lb->u_data)))-1;
       if (*((int*)(lb->u_data))<0)
        *((int*)(lb->u_data))=(*((int*)(lb->u_data)))+1;
      }
     lb=MSListGetElement(rlist,lb->pos+1);
    }

    MSListDelElement(rlist,la->pos);

    _smutex_release(&attacking);
  }
 else
  {
   if (*((int*)(la->u_data))>0)
    if (MMessageDialog("", "Send stop request to selected crack ?", "Yes", "No", NULL))
    return;
   if (*((int*)(la->u_data))<0)
    if (MMessageDialog("", "Cancel stop request sent to selected crack ?", "Yes", "No", NULL))
    return;

   while (!(_smutex_available(&attacking)));
   _smutex_request(&attacking);
   *((int*)(la->u_data))=-(*((int*)(la->u_data)));
   _smutex_release(&attacking);
  }
}

/* Help screen */
void QuitHelp(MOBJECT p, void *s, void *v)
{
 MShellDestroy(p);
}

void Help(MOBJECT o, void *o_data, void *a_data)
{
    MOBJECT shell, form, sfile;
    MOBJECT fname_label,label;

    shell = MCreateShell("Help/About", SF_MODAL);
    form = MCreateColForm(shell);

    fname_label = MCreateLabel(shell, (char *)a_data, FIXED_SMALL);
    sfile = MCreateSFile(shell, (char *)a_data, FIXED_SMALL, 25, 80);
    MObjectSetColor(sfile, seagreen, black);
    MSBLSetHMargin(sfile, 0);
 
    form = MCreateColForm(shell);

    /*    MObjectSetBackgroundRGB(form, 56, 112, 112); */
    label = MCreatePButton(form, "Close", FIXED_SMALL);
    MPButtonSetCallback(label, QuitHelp, 0L);

    MShellRealize(shell);
}

/******* load menu sub routines ***********/
/******************************************/

void LOADRestore(MOBJECT o, void *o_data, void *a_data)
/* we specify o_data, a_data for compatibility issue, but we dump it */
{
 if (OpenRestoreNDS(FALSE,NULL))
  {
   if (slist) /** slist exists after first creation and must be reinitialized **/
    {
     MObjectRemoveEventNotifyCallback(slist, PopupMenuCB, mouse_menu);
     MObjectDestroy(mouse_menu);
     MObjectDestroy(slist);
     slist=NULL;
    }
   ShowPasswordList(2);
  }
}

void LOADPassword(MOBJECT o, void *o_data, void *a_data)
/* we specify o_data, a_data for compatibility issue, but we dump it */
{
 if (OpenPasswordNDS(FALSE,NULL))
  {
   if (slist) /** slist exists after first creation and must be reinitialized **/
    {
     MObjectRemoveEventNotifyCallback(slist, PopupMenuCB, mouse_menu);
     MObjectDestroy(mouse_menu);
     MObjectDestroy(slist);
     slist=NULL;
    }
   ShowPasswordList(1);
  }
}

/* Global Func */

/* called before loading any new value in one of the list items */
/* if loading failed with an error, the screen output is wiped */
void FreeGlobalPandoraMemory()
{
 /* race conditions could occure */
 while (!(_smutex_available(&attacking)));
  _smutex_request(&attacking);
   Pan_PassList_free(pPassList);
   pPassList=NULL;
   Pan_NDSBrowse_free(pNDSBrowse);
   pNDSBrowse=NULL;
   Pan_Connections_free(pConnections);
   pConnections=NULL;
   free(Index);
   Index=NULL;
   free(Index2);
   Index2=NULL;
   free(Index3);
   Index3=NULL;
 _smutex_release(&attacking);
}
