#include "pangui.h"

/* external functions found in output.c */
void BuildLineFromPassList(Pan_PassList q,char *str); /* for output/dump */
void BuildLineFromNDSBrowse(Pan_NDSBrowse q,char *str);
void BuildLineFromConnections(Pan_Connections q,char *str);

void DumpPasswordList(MOBJECT o, void *o_data, void *a_data)
{
 char fname[MAXFNAMELEN]; /* filename */
 char pname[MAXPATHLEN+MAXFNAMELEN];/*path*/
 Pan_PassList q;
 Pan_NDSBrowse r;
 Pan_Connections s;
 FILE *fDump;
 char str[256];
 int i;

  /* Loading the file must happen BEFORE the threading */
selection:
 fname[0] = '\0';
 if (!MFileSelection("Save as...", "*.txt", fname, pname, True)) return;
 strcat(pname,fname);
 if (MMessageDialog("", pname, "Yes", "No", NULL))
goto selection;

 fDump=fopen(pname,"w");  /* Create file */
 if (!fDump)
  {
   MMessageDialog("","Can't create dump file", "Ok", NULL);
   return;
  }

 while (!(_smutex_available(&attacking)));
 _smutex_request(&attacking);

 for (i=0;i<nIndex;i++)
  {
   if(pPassList)
    {
     q=Index[i];
     BuildLineFromPassList(q,str);
    }
   if(pNDSBrowse)
    {
     r=Index2[i];
     BuildLineFromNDSBrowse(r,str);
    }
   if(pConnections)
    {
     s=Index3[i];
     BuildLineFromConnections(s,str);
    }
   strcat(str,"\n");
   fputs(str,fDump);
  }

 _smutex_release(&attacking);

 fclose(fDump);
}

void DumpResultList(MOBJECT o, void *o_data, void *a_data)
{
 char fname[MAXFNAMELEN]; /* filename */
 char pname[MAXPATHLEN+MAXFNAMELEN];/*path*/
 LIST_ACT *la;
 FILE *fDump;
 char str[256];

  /* Loading the file must happen BEFORE the threading */
selection:
 fname[0] = '\0';
 if (!MFileSelection("Save as...", "*.txt", fname, pname, True)) return;
 strcat(pname,fname);
 if (MMessageDialog("", pname, "Yes", "No", NULL))
goto selection;

 fDump=fopen(pname,"w");  /* Create file */
 if (!fDump)
  {
   MMessageDialog("","Can't create dump file", "Ok", NULL);
   return;
  }

 while (!(_smutex_available(&attacking)));
 _smutex_request(&attacking);

 for (la=MSListGetFirstItem(rlist);la!=NULL;la=MSListGetNextItem(rlist))
  {
   strcpy(str,la->item);
   strcat(str,"\n");
   fputs(str,fDump);
  }

 _smutex_release(&attacking);

 fclose(fDump);
}

void CloseDialogCB(MOBJECT p, void *s, void *v)
{
 char *str=(char *)v;

 free(str);
 MShellDestroy(p);
}

void SaveDialogCB(MOBJECT p, void *s, void *v)
{
 char fname[MAXFNAMELEN]; /* filename */
 char pname[MAXPATHLEN+MAXFNAMELEN];/*path*/
 FILE *fDump;
 char *str=(char *)v;

  /* Loading the file must happen BEFORE the threading */
selection:
 fname[0] = '\0';
 if (!MFileSelection("Save as...", "*.txt", fname, pname, True)) return;
 strcat(pname,fname);
 if (MMessageDialog("", pname, "Yes", "No", NULL))
goto selection;

 fDump=fopen(pname,"w");  /* Create file */
 if (!fDump)
  {
   MMessageDialog("","Can't create dump file", "Ok", NULL);
   return;
  }

 fputs(str,fDump);

 fclose(fDump);
}

void DumpValueData(Pan_NDSBrowse q, char *path, char *ext)
{
 char *str;
 char tmp[512];
 uint8 *result;
 uint32 result_lengh,data_lengh;
 int i,j,k,err;
 MOBJECT pbutton, shell, form, stext1;

 union
 {uint8 inBytes[4];
  uint32 asLong;
 } Info;


 err=Pan_GetValueInfo(&result,&result_lengh,&data_lengh,q->objectID,q->typeID,
                      path,ext);
 if (err)
  {
   while (!(_smutex_available(&attacking)));
   _smutex_request(&attacking);

   strcpy(tmp, "An error occured : ");
   strcat(tmp,Pan_error(err));
   MSListAddItem(rlist,tmp,NULL);

   _smutex_release(&attacking);
  }
 else
  {
   str=(char *)calloc(1,((result_lengh*3)+5*(result_lengh/16)+512)*sizeof(char));
   /* x3:2 for uint32/str, 1 for ASCII equiv, +5:4 blanks, 1 end-of-line */
   /* +512:header of object details */
   sprintf(str,"Object : %08lx, Attribute : %08lx\nMeaningfull data: first %d bytes \n",
           q->objectID,q->typeID,(int)data_lengh);
   strcat(str,"\n");
   i=0;
   while(i<result_lengh-4)
    {
     for (k=0;k<4;k++)
      {
       for (j=0;j<4;j++) Info.inBytes[j]=result[i+j];
       sprintf(str+strlen(str),"%08lx ",Info.asLong);
       i+=4;
      }
     for (k=16;k>0;k--)
      {
       str[strlen(str)+1]='\0';
       if (isprint(result[i-k])) str[strlen(str)]=(char)result[i-k];
       else strcat(str,".");
      }
     strcat(str,"\n");
    }

   strcat(str,"\n");
   for(i=0;i<(int)result_lengh;i+=4)
    for(j=0;j<nIndex;j++) if (*((uint32 *)(result+i))==Index2[j]->objectID)
     {
      realloc(str,sizeof(char)*(strlen(Index2[j]->objectStr)+20+strlen(str)));
      sprintf(str+strlen(str),"Word %d may refer to: %s\n",i/4,Index2[j]->objectStr);
      break;
     }
     
   shell = MCreateShell("Value", SF_MODAL);
   form =  MCreateColForm(shell);
   stext1 = MCreateSText(form, str, FIXED_SMALL, 15, 54);
   MObjectSetColor(stext1, seagreen, black);
   MSBLSetHMargin(stext1, 0);
   form =  MCreateColForm(shell);
   pbutton = MCreatePButton(form, "Save", TIMES_MEDIUM);
   MPButtonSetCallback(pbutton, SaveDialogCB, str);
   pbutton = MCreatePButton(form, "Close", TIMES_MEDIUM);
   MPButtonSetCallback(pbutton, CloseDialogCB, str);
   MShellRealize(shell);

   free(result);
  }
}

/****************************************************************************/
