/*************************************************************************
 *                                                                       *
 * nds_stuf.h - header file with NDS fie structures.                     *
 *************************************************************************/

#ifndef PAN_FILE_LOW
#define PAN_FILE_LOW

#include "../pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * struct for ENTRY.NDS records
 */
typedef struct entry
{
	uint32          selfOffset;    /* Offset in ENTRY.NDS. If this is
					  the first record, it is 0x00000000
					  followed by 0x0000014e for the
					  second record, etc. */
	uint32          checkSum;      /* I assume a checksum */
	uint32          val1;          /* Unsure, usually 0xfeffffff. */
	uint32          val2;          /* Unsure, usually 0xffffffff. */
	uint32          peer;          /* Offset to a peer record. */
	uint32          firstChild;    /* Offset to first child record. If
					  no kids, 0xffffffff. */
	uint32          lastChild;     /* Offset to second child record.  If
					  no kids, 0xffffffff. */
	uint32          firstValue;    /* Offset in VALUE.NDS of first
					  attribute. They are usually kept
					  in order in VALUE.NDS, but since
					  they are crossed referenced in
					  VALUE.NDS they don't have to be.*/
	uint32          id;            /* The Object ID of the record. */

	uint32          partitionID;   /* The partition ID of the record.  */
	uint32          parentID;      /* The parent's Object ID, if no
					  parent it is 0xffffffff. */
	uint32          val3;          /* No idea. Usually a small number.*/
        uint32          val4;          /* No idea. 0x00000000. */
	uint32          subordinates;  /* Number of subordinates. This can
					  include other objects besides
					  children. */
	uint32          classID;       /* The "type" of Object ID. */
	uint32		creatTime1,    /* When object was created. */
			creatTime2;
	uint32		modTime1,      /* When object was last modified.  */
			modTime2;
	uint8           name[258];     /* Dreaded unicode describing
				          the record. If a user object
				          it will be the common name.  */
} ENTRY; /* size=334 */
/* O.K pay attention, this gives me fuckin' head aches : declaring         */
/* uint8 names[258] is a problem on 32bits machines since this will really */
/* allocate 260byts to name[] since 334 isn't evenly dividable by 4        */
/* Why ? Simply because the malloc will allocate a contiguous block of     */
/* memory made up of 32 bits chunks, and therefore lenghten our last field.*/
/* So the value of sizeof(ENTRY) will be 336 and not 334 as it should.     */
/* The result is this will fuck-up our nice #define at the end of this file*/
/* if we use a declaration such as #define size_entry sizeof(ENTRY). SO we */
/* really have to declare things "manually" aka : #define size_entry 334,  */
/* I agree to say it's fuckin' ugly and could lead to mistakes, but hey it */
/* works...                                                                */

/*
 * struct for VALUE.NDS records
 */
typedef struct value
{
	uint32          selfOffset;    /* Offset in VALUE.NDS. If this is
					  the first record, it is 0x00000000
					  followed by 0x00000040 for the
					  second record, etc. */
	uint32          checkSum;      /* I assume a checksum */
	uint32          val1;          /* Unsure, usually 0xfeffffff. */
	uint32          val2;          /* Unsure, usually 0xffffffff. */
	uint32          nextVal;       /* The next Value record's offset.  */
	uint32          firstBlock;    /* Offset in BLOCK.NDS if used. */
	uint32          entryID;       /* Type of record in ENTRY.NDS. */
	uint32          typeID;        /* Type of VALUE record. */
	uint32          val3;          /* No idea. Usually a small number.*/
	uint32          creatTime1,    /* When object was created(?). */
			creatTime2;
	uint32          length;        /* Length of data. */
	uint8           data[16];      /* Start of data, unless there is a
					  small amount of data, then it's
					  all here. */
} VALUE; /* size=64  */



/*
 * struct for BLOCK.NDS records
 */
typedef struct block
{
	uint32          selfOffset;    /* Offset in BLOCK.NDS. If this is
					  the first record, it is 0x00000000
					  followed by 0x00000080 for the
					  second record, etc. */
	uint32          checkSum;      /* I assume a checksum */
	uint32          val1;          /* Unsure. */
	uint32          nextBlock;     /* Next record if data>120. */
	uint32          valueOffset;   /* Offset in VALUE.NDS (backlink) */
	uint8           data[108];
} BLOCK; /* size=128 */



/*
 * struct for PARTITION.NDS records
 */
typedef struct partition
{
	uint32          selfOffset;    /* Offset in PARTITIO.NDS. If this is
					  the first record, it is 0x00000000
					  followed by 0x00000028 for the
					  second record, etc. */
	uint32          checkSum;      /* I assume a checksum */
	uint32          val1;          /* Unsure. */
	uint32          id;            /* ID of record. */
	uint32          entryID;       /* ID in ENTRY.NDS */
	uint32          replicaID;     /* Replica ID (??) in ENTRY.NDS */
	uint32          val2;          /* Unsure. */
	uint32          val3;          /* Unsure. */
	uint32          timeStamp1,    /* Probably used to keep things in sync */
			timeStamp2;
} PARTITIO; /* size=40 */

/** I/O level structures **/
typedef struct passlist
{
 uint8 bind[8];         /* Type of bindery object, see end of file */
 uint8 id[8];           /* Object ID from ENTRY */
 uint8 parentID[8];     /* Parent ID */
 uint8 objectID[8];     /* Object ID from Private Key */
 uint8 pwlen_known[8];  /* TRUE or FALSE */
 uint8 pwlen[8];        /* Password length of user account */
 uint8 pwhash_known[8]; /* TRUE or FALSE */
 uint8  hash[16];       /* One-way hash */
 uint8  userOU[40];     /* OU of User */
 uint8  userCN[258];    /* User common name */
 uint8  password[258];  /* User password */
} PASSLIST; /* size=628 */

typedef struct passhack
{
 uint8 bind[8];         /* Type of bindery object, see end of file */
 uint8 id[8];           /* Object ID from ENTRY */
 uint8 parentID[8];     /* Parent ID */
 uint8 objectID[8];     /* Object ID from Private Key */
 uint8 pwlen[8];        /* Password length currently tested */
 uint8  pw_first[128];  /* Passwd used to initialize the hack */
 uint8  pw_current[128];/* Last attempt saved */
 uint8  pw_last[128];   /* Last attempt to perform */
 uint8  key_space[PAN_KEYSPACE+1]; /* Key space used for brute force */
 uint8  hash[16];       /* One-way hash if set to 0 => unknown */
 uint8  userOU[40];     /* OU of User */
 uint8  userCN[258];    /* User common name */
} PASSHACK; /* size=806 */

#define size_entry 334
#define size_value 64
#define size_block 128
#define size_partitio 40
#define size_passlist 628 /* file output size per record */
#define size_passhack 807 /* file output size */

typedef struct nw4dibrecord {
  uint8 filename[16];
  uint32 length;
} NW4DIBRECORD;

typedef struct nw5dibrecord {
  uint32 filenum;
  uint32 length;
} NW5DIBRECORD;

typedef struct nw5backupnds {
  uint32 startofdsd;
  uint32 endofdsd;
} NW5BACKUPNDS;


#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_LOW */
