#include <stdio.h>
#include "..\pandora\pan_file.h"

void printHelp(int j)
{
   printf("\nUSAGE: extract -n|b|d -p <path>\n");
   printf("               -h prints this HELP file.\n");
   printf("EXAMPLE:\n");
   printf(" extract -d              convert backup.ds in the .nds files first\n");
   printf(" extract -n              extract NDS password from files in current directory\n");
   printf(" extract -b -p f:\\nds\\   extract Bindery password from files in specified dir\n\n");
   exit(j);
}

int main(int argc, char *argv[])
{
 int err,i,FOUND=FALSE,choice=FALSE;
 Pan_PassList pPassList,q;
 char *path=(char *)calloc(1,sizeof(char)*MAX_CHARS+10);

 /* Say hello... */
 printf("\n\nEXTRACT - Extract the password information from NDS files\n");
 printf("          default path is current directory\n");
 printf("Comments/bugs: pandora@nmrc.org\n");
 printf("http://www.nmrc.org/pandora\n");
 printf("1997,1998 (c) Nomad Mobile Research Centre\n");

 if (argc<2) printHelp(1);

 /* process command line switches, if any... */
 for (i=1 ; i<argc ; i++)
  {
   if (argv[i][0]=='-')
    switch(argv[i][1])
     {
      case 'h':
      case 'H':
      case '?':
       printHelp(0);
      case 'p':
      case 'P':
       if ((i+1>argc) || argv[i+1]==NULL)
        {
         printf("No argument given for option -p\n");
         printHelp(-1);
        }
       if (argv[i+1][0]=='-')
        {
         printf("No argument given for option -p\n");
         printHelp(-1);
        }
       sprintf(path,"%s",argv[i+1]);
       FOUND=TRUE;
       break;
      case 'n':
      case 'N':
       choice=1;
       break;
      case 'b':
      case 'B':
       choice=2;
       break;
      case 'd':
      case 'D':
       choice=3;
       break;
      default:
       printf("Invalid option: %s\n", argv[i]);
       printHelp(-1);
     }
  }

 if (!choice) {printf("\n Must choose an option");
               exit(-1);
              }
 if (!FOUND) sprintf(path,"%s",".\\");

 if (choice==3)
  {err=Pan_Convert_DS(path);
   if (err) printf("err : %d",err);
   exit(0);
  }

 if (choice==2)
  {err=Pan_Extract_Bindery(&pPassList,path);
   if (err) {printf("\nerr reading : %d",err);
             exit(-1);
            }
  }

 if (choice==1)
  {err=Pan_Extract_NDS(&pPassList,path);
   if (err) {printf("\nerr reading : %d",err);
             exit(-1);
            }
  }

 err=Pan_PassList_write((char *)strcat(path,"PASSWORD.NDS"),pPassList);
 path[strlen(path)-9]='\0'; /* UGLY but effective trick to keep the "path" */
                            /* clean ... */

 if (err) {printf("err writing : %d",err);
           exit(-1);
          }

 for (q=pPassList;q!=0;q=q->next)
  {
   printf("\n");
   printUnicodeName(q->userCN,258);
   printf(" ");
   printUnicodeName(q->userOU,40);
   printf(" %08lx %d ",q->objectID,q->pwlen);
   for (i=0;i<16;i++) printf("%02x",q->hash[i]);
  }

 Pan_PassList_free(pPassList);
}
