/*************************************************************************
 *                                                                       *
 * Project Pandora Password Hash and Hack Functions                      *
 *************************************************************************/

#ifndef PAN_GLOB_H
#define PAN_GLOB_H

#ifdef __cplusplus
extern "C" {
#endif

/* Type of OS */
#ifdef BIG_ENDIAN
  #define PAN_OS 'B'
#else
#if PDP_ENDIAN
  #define PAN_OS 'P'
#else
  #define PAN_OS 'L'
#endif
#endif

/*
 * Global constants
 */
#define TRUE 1
#define FALSE 0 
#define VERS "Project Pandora v.3"
#define MAX_CHARS 128

/** API structures **/
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;
typedef unsigned int  unicode;

typedef struct pan_passlist
{
 uint32                 bind;           /* Bindery type of object */
 uint32                 id;             /* Object ID from ENTRY */
 uint32                 parentID;       /* Parent ID */
 uint32                 objectID;       /* Object ID from Private Key */
 uint32                 pwlen_known;    /* TRUE or FALSE */
 uint32                 pwlen;          /* Password length of user account */
 uint32                 pwhash_known;   /* TRUE or FALSE */
 uint8                  hash[16];       /* One-way hash */
 uint8                  userOU[40];     /* OU of User */
 uint8                  userCN[258];    /* User common name */
 struct pan_passlist    *next;
} *Pan_PassList;

typedef struct pan_passhack
{
 uint32 bind;                   /* Bindery type of object */
 uint32 id;                     /* Object ID from ENTRY */
 uint32 parentID;               /* Parent ID */
 uint32 objectID;               /* Object ID from Private Key */
 uint32 pwlen;                  /* Password length currently tested */
 uint8  pw_first[128];          /* Passwd used to initialize the hack */
 uint8  pw_current[128];        /* Last attempt saved */
 uint8  pw_last;                /* Max for pw_current[0] */
 uint8  hash[16];               /* One-way hash if set to 0 => unknown */
 uint8  userOU[40];             /* OU of User */
 uint8  userCN[258];            /* User common name */
} Pan_PassHack;

/** API functions **/

 /* Dump unicode to screen. */

 void printUnicodeName(char *name, int j);

 /* Memory alloc/desalloc for the name&password list */

  /*Usage : Pan_PassList pPassList=Pan_PassList_alloc();*/
  /* allocates memory for a record */
 Pan_PassList Pan_PassList_alloc(void);

  /*Usage : Pan_PassList_free(pPassList);*/
  /* free the memory of a record and all records under it */
 void Pan_PassList_free(Pan_PassList pPassList);

  /*Usage : Pan_PassList_to_PassHack(pPassList,&pPassHack); */
  /* fill a PassHack record with current PassList pointed info */
 void Pan_PassList_to_PassHack(Pan_PassList pPassList,Pan_PassHack *pPassHack);

  /* Endian Games */

  uint32 swap_uint32(uint32 n); /* uint32 BIG<->LITTLE Endian */

  uint16 swap_uint16(uint16 n); /* uint16 BIG<->LITTLE Endian */

#ifdef __cplusplus
}
#endif

#endif /* PAN_GLOB_H */
