#ifndef PAN_FILE_LIB
#define PAN_FILE_LIB

#include "file_med.h"

#ifdef __cplusplus
extern "C" {
#endif

/*********** API Level Functions *******/

int Pan_Extract_NDS(Pan_PassList *pPassList, char *path)
{
 *pPassList=Pan_PassList_alloc();
 if (*pPassList==NULL) return(-201);
 return(extract(*pPassList,1,path));
}

int Pan_Extract_Bindery(Pan_PassList *pPassList, char *path)
{
 *pPassList=Pan_PassList_alloc();
 if (*pPassList==NULL) return(-201);
 return(extract(*pPassList,2,path));
}

int Pan_Convert_DS(char *path)
{
 return(convert(path));
}

int Pan_PassList_read(char *readfile,Pan_PassList *pPassList)
{
 FILE *fPassList; PASSLIST record;
 Pan_PassList tmp;
 int TEST=FALSE;

 /* Allocate memory before reading file to solve abend pb when calling */
 /* Pan_free(..) with no calloc done on the argument */
 *pPassList=Pan_PassList_alloc(); /* Allocate first block of memory */
 if (*pPassList==NULL) return(-201);
 tmp=*pPassList;

 fPassList=fopen(readfile,"rb");  /* Open file */
 if (!fPassList) return(-300);
 rewind(fPassList);

 while (!feof(fPassList))
  {
    if(fread(&record,size_passlist,1,fPassList))
     {
      if (TEST)
      {tmp->next=Pan_PassList_alloc();
       if (tmp->next==NULL) return(-201);
       tmp=tmp->next;
      }
      record_to_pPassList(&record,tmp);
      TEST=TRUE; /*We have to do this dumb TEST thing, otherwise we*/
     }           /*allways allocate one more record than needed*/
  }
  fclose(fPassList);
  return(0);
}

int Pan_PassList_write(char *writefile,Pan_PassList pPassList)
{
 FILE *fPassList; PASSLIST record;
 Pan_PassList q;

 fPassList=fopen(writefile,"wb");  /* Open file */
 if (!fPassList) return(-300);

 for (q=pPassList;q!=NULL;q=q->next)
  {
    pPassList_to_record(q,&record);
    if(!fwrite(&record,size_passlist,1,fPassList))
     {fclose(fPassList);
      return(-301);
     }
  }
  fclose(fPassList);
  return(0);
}

int Pan_PassHack_read(char *readfile,Pan_PassHack *pPassHack)
{
 FILE *fPassHack; PASSHACK record;

 fPassHack=fopen(readfile,"rb");  /* Open file */
 if (!fPassHack) return(-300);
 rewind(fPassHack);

 if (!fread(&record,size_passhack,1,fPassHack)) return(-301);
 record_to_pPassHack(&record,pPassHack);

 fclose(fPassHack);
 return(0);
}

int Pan_PassHack_write(char *writefile,Pan_PassHack *pPassHack)
{
 FILE *fPassHack; PASSHACK record;

 fPassHack=fopen(writefile,"wb");  /* Open file */
 if (!fPassHack) return(-300);

 pPassHack_to_record(pPassHack,&record);
 if (!fwrite(&record,size_passhack,1,fPassHack)) return(-301);

 fclose(fPassHack);
 return(0);
}
/***********************End of API level functions****************/


#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_LIB */
