/*
 *  nwfstime.c
 *
 *  get/set a file server's time
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include <stdio.h>
#include <unistd.h>
#include "ncplib.h"

static char *progname;

static void
usage(void)
{
	fprintf(stderr, "usage: %s [pattern]\n", progname);
}

static void
help(void)
{
	printf("\n");
	printf("usage: %s [options]\n", progname);
	printf("\n"
	       "-h             Print this help text\n"
	       "-S server      Server name to be used\n"
	       "-U username    Username sent to server\n"
	       "-P password    Use this password\n"
	       "-n             Do not use any password\n"
	       "-C             Don't convert password to uppercase\n"
	       "\n"
	       "-s             Set file server's time from local time\n"
	       "\n");
}

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;
	int opt;
	long err;
	int set = 0;
	time_t t;

	progname = argv[0];

	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, "when initializing");
		return 1;
	}
	while ((opt = getopt(argc, argv, "h?s")) != EOF)
	{
		switch (opt)
		{
		case 'h':
		case '?':
			help();
			break;
		case 's':
			set = 1;
			break;
		default:
			usage();
			goto finished;
		}
	}

      finished:

	if (set != 0)
	{
		time(&t);
		if ((err = ncp_set_file_server_time(conn, &t)) != 0)
		{
			com_err(argv[0], err, "when setting file server time");
			ncp_close(conn);
			return 1;
		}
	} else
	{
		if ((err = ncp_get_file_server_time(conn, &t)) != 0)
		{
			com_err(argv[0], err, "when getting file server time");
			ncp_close(conn);
			return 1;
		}
		fputs(ctime(&t), stdout);
	}

	ncp_close(conn);
	return 0;
}
