#ifndef PAN_UNIX
 /* Win32 packet driver */
 #include "../packet32/include/packet32.h" /* soon to be removed */
 extern LPADATER Pan_Adapter;
 extern LPPACKET Pan_Packet;
#else
 /* packet library for spoof/sniff : LibNet/LibPCap  */
 #include "../packet/include/libnet_p.h"
 #include "../packet/include/pcap_p.h"
 #include <fcntl.h>
 #define MAX_IPADDR 32

 struct _pan_adapter
   {
    struct libnet_link_int *l;      /* libnet packet injection structure */
    pcap_t *p;                      /* pcap packet listening structure */
   };

 typedef struct _pan_adapter *pan_adapter;

 pan_adapter Pan_Adapter;
#endif

/* NCP handling from NCPFS project by Volker Lendke */
#include "../ncp/include/ncplib.h"
/* connection structure used in NCP send/receive/login */
struct ncp_conn *pan_conn=NULL;
struct ncp_conn_spec *pan_spec=NULL;

/* common Pandora GUI code base */
/* some definitions has to superseed the above */
/* specifically NULL pointer declaration */
#include "../common/pangui.h"

uint8  *buffer_p;
uint32 *length_p;

/******************* first part : NCP send and reply ************************/
void StartPanServ()
{
 pan_spec = calloc(1,sizeof(struct ncp_conn_spec));
 preference.default_server[0]='\0';
}

int GUI_Pan_NCP_connect()
{                      /* NULL for default server */
 const char *server = NULL;
 struct sockaddr_ipx addr;
 long err;

 /* let's see if we can attach to the server, in case we are */
 /* actually logged-in with a username */

 strncpy(pan_spec->server,preference.default_server,NCP_BINDERY_NAME_LEN);

 if ((pan_conn = ncp_open(pan_spec, &err)) == NULL)
  {
   if (preference.default_server[0]) server=preference.default_server;
   else server=NULL;
   err = ncp_find_server(&server,
                         NCP_BINDERY_FSERVER,
                         (struct sockaddr*)&addr,
                         sizeof(addr));
   if (err) return(-400);

   pan_conn = ncp_open_addr((struct sockaddr*)&addr, &err);
   if (err) return(-400);
  }
 return(0);
}

void GUI_Pan_NCP_disconnect()
{
 if(pan_conn) ncp_close(pan_conn);
}

int GUI_Pan_NCP_transmit(int func,uint8 *req,int rlengh,uint8 *ans,int alengh)
{
 long result;

 ncp_init_request(pan_conn);
 if (req[2]) pan_conn->has_subfunction=1;
 pan_conn->current_size+=rlengh;

 memcpy(&(pan_conn->packet[sizeof(struct ncp_request_header)]),req,rlengh);
 result = ncp_request(pan_conn,func);
 memcpy(ans,ncp_reply_data(pan_conn,0),alengh);

 ncp_unlock_conn(pan_conn);
 return pan_conn->completion;
}

int GUI_Pan_NCP_DoS(int func,uint8 *req,int rlengh,uint8 *ans,int alengh,
                    int rtime)
{

 int i;
 for(i=0;i<rtime;i++)
  GUI_Pan_NCP_transmit(func,req,rlengh,ans,alengh);
 return 0;
}

void StopPanServ()
{
 free(pan_spec);
}
/****************************************************************************/

/******************* second part : packet spoof/sniff ***********************/
void GUI_Pan_Adapter_Names(char names[4][132])
{
 /* this will retreive up to four possible adapter names in your PC */
 /* if you have more than that, WELL FUCK, get a PC, not a server */
 
 register int fd, nipaddr;
 #ifdef HAVE_SOCKADDR_SA_LEN
 register int n;
 #endif
 register struct ifreq *ifrp, *ifend, *ifnext, *mp;
 struct ifconf ifc;
 struct ifreq ibuf[MAX_IPADDR], ifr;
 char device[sizeof(ifr.ifr_name) + 1];
 int device_num=0;

 memset(names[0],0,132);
 memset(names[1],0,132);
 memset(names[2],0,132);
 memset(names[3],0,132);

 fd = socket(AF_INET, SOCK_DGRAM, 0);
 if (fd < 0) return;

 ifc.ifc_len = sizeof(ibuf);
 ifc.ifc_buf = (caddr_t)ibuf;

 if (ioctl(fd,
     SIOCGIFCONF,
     (char *)&ifc) < 0 || ifc.ifc_len < sizeof(struct ifreq))
  {
   close(fd);
   return;
  }

 ifrp = ibuf;
 ifend = (struct ifreq *)((char *)ibuf + ifc.ifc_len);

 mp = NULL;
 nipaddr = 0;

 for (; ifrp < ifend; ifrp = ifnext)
  {
   #ifdef HAVE_SOCKADDR_SA_LEN
   n = ifrp->ifr_addr.sa_len + sizeof(ifrp->ifr_name);
   if (n < sizeof(*ifrp)) ifnext = ifrp + 1;
   else ifnext = (struct ifreq *)((char *)ifrp + n);
   if (ifrp->ifr_addr.sa_family != AF_INET) continue;
   #else
   ifnext = ifrp + 1;
   #endif
   /*
    * Need a template to preserve address info that is
    * used below to locate the next entry.  (Otherwise,
    * SIOCGIFFLAGS stomps over it because the requests
    * are returned in a union.)
    */
   strncpy(ifr.ifr_name, ifrp->ifr_name, sizeof(ifr.ifr_name));
   if (ioctl(fd, SIOCGIFFLAGS, (char *)&ifr) < 0)
    {
     if (errno == ENXIO) continue;
     close(fd);
     return;
    }

   /* Must be up and not the loopback */
   if ((ifr.ifr_flags & IFF_UP) == 0 || LIBNET_ISLOOPBACK(&ifr))
    continue;
        
   strncpy(device, ifr.ifr_name, sizeof(ifr.ifr_name));
   device[sizeof(device) - 1] = '\0';

   if (ioctl(fd, SIOCGIFADDR, (char *)&ifr) < 0)
    {
     close(fd);
     return;
    }        

   strncpy(names[device_num++],device,132);
  }
 close(fd);
}

int GUI_Pan_Open_Adapter(char *AdapterName)
{
 char err_buf[4096];

 Pan_Adapter=(pan_adapter)malloc(sizeof(struct _pan_adapter));
 
 
 if (
     (!(Pan_Adapter->l=libnet_open_link_interface(AdapterName,err_buf))) ||
     (!(Pan_Adapter->p=pcap_open_live(AdapterName,MAX_PACKET_LENGTH,TRUE,0,err_buf)))
    )
  {
   free(Pan_Adapter);
   Pan_Adapter=NULL;
   return(-206);
  }

 strncpy(preference.default_interface,AdapterName,131);

 return(0);
}

void GUI_Pan_Close_Adapter()
{
 if (Pan_Adapter)
  {
   pcap_close(Pan_Adapter->p);
   libnet_close_link_interface(Pan_Adapter->l);
   free(Pan_Adapter->l);
   free(Pan_Adapter);
  }
}

void GUI_Pan_RealTime_Adapter()
{
 fcntl((Pan_Adapter->p)->fd,F_SETFL,O_NONBLOCK);
}

void GUI_Pan_Buffered_Adapter(int buffer_size)
{
 /* the default operating mode when the packet capture starts, is a */
 /* buffered mode. We can switch to RealTime (see above), but then  */
 /* I don't know how to switch back to buffered mode, so lets just  */
 /* restart the packet driver */
 GUI_Pan_Close_Adapter();
 GUI_Pan_Open_Adapter(preference.default_interface);
}

void GUI_Pan_Spoof_One(uint8 *Pan_buffer, uint32 length)
{
 libnet_write_link_layer(Pan_Adapter->l,preference.default_interface,
                         Pan_buffer,(int)length);
}

int GUI_Pan_Sniff_One(uint8 *Pan_buffer, uint32 *length)
{
 register int cc,good_cc=0;
 struct pcap_pkthdr h;

 /* The game consists in emptying the buffer until we reach for length=-1 */
 /* which means, the driver buffer holds the most recent valid packet */
 cc=recv ((Pan_Adapter->p)->fd,(void *)Pan_buffer, MAX_PACKET_LENGTH, MSG_OOB);
 while (cc>0)
  {
   good_cc=cc;
   cc = recv ((Pan_Adapter->p)->fd,(void *)Pan_buffer, MAX_PACKET_LENGTH, MSG_OOB);
  }

 /* Captured length can't exceed our read buffer size */
 if (good_cc > MAX_PACKET_LENGTH) *length=MAX_PACKET_LENGTH;
 else *length=good_cc;

 /* Get timestamp */
 if (ioctl((Pan_Adapter->p)->fd, SIOCGSTAMP, &h.ts) < 0) return(-1);

 /* return timestamp (seconds) */
 return((int)h.ts.tv_sec);
}

void dispatcher_handler(u_char *temp,
	const struct pcap_pkthdr *header, const u_char *pkt_data)
{
 *length_p=header->caplen;
 memcpy(buffer_p,pkt_data,*length_p);
};

void GUI_Pan_Sniff_from_Multi(uint8 *Pan_buffer, uint32 *length)
{
 buffer_p=Pan_buffer;
 length_p=length;
 pcap_read(Pan_Adapter->p,1,dispatcher_handler,NULL);
}
/****************************************************************************/

