/*************************************************************************
 *                                                                       *
 * Project Pandora Password Hash and Hack Functions                      *
 *************************************************************************/

#ifndef PAN_GLOB_H
#define PAN_GLOB_H

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Type of OS */
#ifdef BIG_ENDIAN
  #define PAN_OS "B"
#else
#ifdef PDP_ENDIAN
  #define PAN_OS "P"
#else
  #define PAN_OS "L"
#endif
#endif

/*
 * Global constants
 */
#define TRUE 1
#define FALSE 0 
#define VERS "Project Pandora v.4"
#define MAX_CHARS 128
#undef NULL
#define NULL 0

#if !defined PAN_UNIX
	#include <sys\stat.h>
	#if defined _MSC_VER || defined __WATCOMC__
		#include <stdlib.h>
		#define MAXPATHLEN	_MAX_PATH
		#define MAXFNAMELEN	_MAX_FNAME
	#else
                #include <dir.h>
                #include <values.h> 
		#ifdef __GO32__
			#define MAXPATHLEN	260
			#define MAXFNAMELEN	64
		#else
			#define MAXPATHLEN	MAXPATH
			#define MAXFNAMELEN	(MAXFILE+MAXEXT)
		#endif
	#endif
	#define EXT		"*.*"
#else
	#include <sys/stat.h>
        #include <sys/param.h> /* for MAXPATHLEN */
	#define MAXFNAMELEN	64
	#define EXT		"*"
#endif

#define PAN_ASCII 26
#define PAN_ALPHANUM 36
#define PAN_KEYSPACE 68

#define MAXPASSLEN 128
#define MAXNAMELEN 48
#define MAXNCPREPLYLEN 130
#define NCP_PACKET_SIZE 4070

#define PAN_TYPE_SERVER 0x0400
#define PAN_TYPE_USER   0X0100
#define PAN_TYPE_OTHER  0XFFFF

/* since Packet driver rel2, a BPF header is attached to the
   packet received, the length depends on the platform */
#ifdef UNIX
 #define PAN_BPF_LEN 0
#endif

#ifndef PAN_UNIX
 #ifdef PAN_NT
  #define PAN_BPF_LEN 20
 #else
  #define PAN_BPF_LEN 18
 #endif
#endif

#define MAX_PACKET_LENGTH 1514+PAN_BPF_LEN  // (MAC ethernet/802.3)


extern char Pan_Key_Space[PAN_KEYSPACE+1];


/** API structures **/
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;
typedef unsigned int  unicode;

typedef struct pan_passlist
{
 uint32                 bind;           /* Bindery type of object */
 uint32                 id;             /* Object ID from ENTRY */
 uint32                 parentID;       /* Parent ID */
 uint32                 objectID;       /* Object ID from Private Key */
 uint32                 pwlen_known;    /* TRUE or FALSE */
 uint32                 pwlen;          /* Password length of user account */
 uint32                 pwhash_known;   /* TRUE or FALSE */
 uint8                  hash[16];       /* One-way hash */
 uint8                  userOU[40];     /* OU of User */
 uint8                  userCN[258];    /* User common name */
 uint8                  password[258];  /* User password */
 struct pan_passlist    *next;
} *Pan_PassList;

typedef struct pan_passhack
{
 uint32 bind;                   /* Bindery type of object */
 uint32 id;                     /* Object ID from ENTRY */
 uint32 parentID;               /* Parent ID */
 uint32 objectID;               /* Object ID from Private Key */
 uint32 pwlen;                  /* Password length currently tested */
 uint8  pw_first[128];          /* Passwd used to initialize the hack */
 uint8  pw_current[128];        /* Last attempt saved */
 uint8  pw_last[128];           /* Last attempt to perform */
 uint8  key_space[PAN_KEYSPACE+1]; /* Key space used for brute force */
 uint8  hash[16];               /* One-way hash if set to 0 => unknown */
 uint8  userOU[40];             /* OU of User */
 uint8  userCN[258];            /* User common name */
} Pan_PassHack;

typedef struct pan_ndsbrowse
{
 uint32                 objectID;       /* Object ID */
 uint32                 parentID;       /* Parent ID */
 uint32                 typeID;         /* Attrinute ID */
 uint8                  parentStr[128];  /* Parent String NOT UNICODE */
 uint8                  objectStr[128];  /* Object String NOT UNICODE */
 uint8                  typeStr[128];    /* Object String NOT UNICODE */
 struct pan_ndsbrowse   *next;
} *Pan_NDSBrowse;
/* WTF didn't we kept Unicode shit here since we kept it everywhere else ??
   Just because this memory structure is not meant (or never should :-) )
   to be dumped to the disk */

typedef struct pan_connections
{
 char                   name[MAXNAMELEN+1];   /*connection name*/
 int                    conn_type;   /*server, user, other*/
 uint8                  conn_number; /*connection number*/
 uint8                  ipx_net[4];  /*IPX network*/
 uint8                  ipx_addr[6]; /*IPX adress*/
 uint8                  sock_high;   /*socket high*/
 uint8                  sock_low;    /*socket low*/
 char                   details[512];/*comment string to store connection details*/
 struct pan_connections *next;
} *Pan_Connections;

/** API functions **/

 /* Dump unicode to string. */
 void sprintUnicodeName(char *output,char *name, int j);

 /* Make unicode from string. */
 void MakeUnicodeName(char *string);

 /* Return error meaning for given value*/
 char *Pan_error(int number);

 /* Memory alloc/desalloc for the name&password list */

  /*Usage : Pan_PassList pPassList=Pan_PassList_alloc();*/
  /* allocates memory for a record */
 Pan_PassList Pan_PassList_alloc(void);
 Pan_NDSBrowse Pan_NDSBrowse_alloc(void);
 Pan_Connections Pan_Connections_alloc(void);

  /*Usage : Pan_PassList_free(pPassList);*/
  /* free the memory of a record and all records under it */
 void Pan_PassList_free(Pan_PassList pPassList);
 void Pan_NDSBrowse_free(Pan_NDSBrowse pNDSBrowse);
 void Pan_Connections_free(Pan_Connections pConnections);

  /*Usage : Pan_PassList_to_PassHack(pPassList,&pPassHack); */
  /* fill a PassHack record with current PassList pointed info */
 void Pan_PassList_to_PassHack(Pan_PassList pPassList,Pan_PassHack *pPassHack);

  /*Usage : PassHack_in_Pan_PassList(&pPassHack,pPassList); */
  /* fill current pointed PassList record with PassHack values */
 void PassHack_in_Pan_PassList(Pan_PassHack *pPassHack,Pan_PassList pPassList);

  /*Usage : PassHack_to_PassHack(&pPassHack,&pPassHack); */
  /* fill current pointed PassHack record with PassHack values */
 void PassHack_to_PassHack(Pan_PassHack *aPassHack,Pan_PassHack *bPassHack);

  /* Endian Games */

  uint32 swap_uint32(uint32 n); /* uint32 BIG<->LITTLE Endian */

  uint16 swap_uint16(uint16 n); /* uint16 BIG<->LITTLE Endian */

  /* string to anything and versa */

  uint32 str_to_uint32(uint8 *in); /* string to uint32 */

  uint8 str_to_uint8(char *in); /* string to uint8 */

  void uint32_to_str(uint32 in, uint8 *out); /* uint32 to a string */

  void str_to_hex(char *in,uint8 *out,int size_string); /* string to hex */
                                                              /* length > 1 */
#ifdef __cplusplus
}
#endif

#endif /* PAN_GLOB_H */
