/*
 * radius.h	Some radius stuff, dude.
 *
 * Version:	$Id: radius.h,v 1.2 2001/02/07 17:07:52 miquels Exp $
 *
 */

typedef struct {
	unsigned char	code;
	unsigned char	id;
	unsigned short	len;
	unsigned char	vector[16];
	unsigned char	data[2];
} RAD_PACKET;

typedef struct {
	unsigned int	source;
	unsigned int	server1;
	unsigned short	port1;
	unsigned int	server2;
	unsigned short	port2;
	char		user_name[254];
	char		password[254];
	char		nas_id[254];
	unsigned int	nas_ip;
	char		secret[128];
} RAD_REQUEST;

typedef struct {
	int		code;
	char		reply[128];		/* Reply-Message */
	char		groups[254];		/* Login-LAT-Group, CSV */
} RAD_REPLY;

/* Misc definitions */
#define RAD_AUTH_PORT			1645
#define RAD_TYPE_STRING			0
#define RAD_TYPE_IPADDR			2

/* Radius packet codes. */
#define RAD_AUTHREQ			1
#define RAD_AUTHACK			2
#define RAD_AUTHREJ			3

/* Attribute definitions. */
#define RAD_USER_NAME			1
#define RAD_PASSWORD			2
#define RAD_NAS_IP_ADDRESS		4
#define RAD_SERVICE_TYPE		6
#define RAD_REPLY_MESSAGE		18
#define RAD_GROUP			36	/* Login-LAT-Group */
#define RAD_NAS_IDENTIFIER		32

#define RAD_AUTHENTICATE_ONLY		8

