/*
 * test.c	Test the radius.c routines.
 *
 * Version:	$Id: test.c,v 1.2 2001/02/07 17:07:52 miquels Exp $
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <netinet/in.h>

#include "radius.h"

int main(int argc, char **argv)
{
	RAD_REQUEST	req;
	RAD_REPLY	rep;

	if (argc < 5) {
		fprintf(stderr, "Usage: %s username password secret server\n",
			argv[0]);
		exit(1);
	}

	memset(&req, 0, sizeof(req));
	strcpy(req.user_name, argv[1]);
	strcpy(req.password, argv[2]);
	strcpy(req.secret, argv[3]);
	strcpy(req.nas_id, "www.dildo.nl");
	req.nas_ip = inet_addr("212.29.166.143");
	req.server1 = inet_addr(argv[4]);
	if (argv[5]) req.server2 = inet_addr(argv[5]);

	if (rad_client(&req, &rep) < 0) {
		perror("radclient");
		exit(1);
	}

	printf("code %d\n", rep.code);
	printf("reply %s\n", rep.reply);
	printf("groups %s\n", rep.groups);

	return 0;
}

