/*
 * mytls.h	header for EAP-TLS.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002  hereuare Communications <raghud@hereuare.com>
 */

#ifndef _MY_TLS_H
#define _MY_TLS_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <fcntl.h>
#include <signal.h>

#include <ctype.h>
#include <sys/time.h>
#include <arpa/inet.h>

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef NO_OPENSSL
#include <openssl/err.h>
#include <openssl/engine.h>
#include <openssl/ssl.h>
#endif /* !defined(NO_OPENSSL) */

#define BUFSIZE 		1024
#define FRAGMENT_SIZE 	2048
#define MAX_RECORD_SIZE 16384

/* These #defines should be command line arguments */
#define CA_LIST  "root.pem"
#define KEYFILE  "client.pem"
#define RANDOM   "random.pem"
#define PASSWORD "password"

typedef struct _record_t {
	unsigned char data[MAX_RECORD_SIZE];
	unsigned int used;
} record_t;

typedef struct _session_t {
	char 		type[4];
	SSL 		*ssl;
	BIO 		*into_ssl;
	BIO 		*from_ssl;
	record_t	clean_in;
	record_t	clean_out;
	record_t	dirty_in;
	record_t	dirty_out;
} session_t;

typedef struct _tls_stuff_t {
	session_t	*ssn;     /* 'n' SSL connections at a time */
	SSL_CTX		*tls_ctx; /* Global SSL context */
} tls_stuff_t;

void close_session(session_t *machine);

/* Callbacks */
void cb_ssl_info(SSL *s, int where, int ret);
int cb_ssl_verify(int ok, X509_STORE_CTX *ctx);
void msg_cb(int write_p, int version, int content_type, const void *buf, size_t len, SSL *ssl, void *arg);

int tls_write(session_t *ssn);
int tls_read(session_t *ssn);
SSL_CTX *init_tls_ctx( char *keyfile, char *password);
int new_tls_connection(tls_stuff_t *tstuff, session_t **ssn);
unsigned int from_record(record_t *rec, unsigned char *ptr,
		unsigned int size);

#endif /* _MY_TLS_H */
