/*
 * tls.c	Main EAP-TLS.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002  hereuare Communications <raghud@hereuare.com>
 */

#include "mytls.h" 

/*
 * SSL stuff
 */
BIO *bio_err = 0;
/* A simple error and exit routine*/
int err_exit(char *string)
{
    fprintf(stderr, "%s\n", string);
    exit(0);
}

/* Print SSL errors and exit*/
int berr_exit(char *string)
{
    BIO_printf(bio_err, "%s\n", string);
    ERR_print_errors(bio_err);
    exit(0);
}

static int password_cb(char *buf, int num, int rwflag, void *userdata)
{
    strcpy(buf, PASSWORD);
    return(strlen(PASSWORD));
}

static void int_ssl_check(SSL *s, int ret)
{
	int e = SSL_get_error(s, ret);

	switch(e) {
	case SSL_ERROR_NONE:
	case SSL_ERROR_WANT_READ:
	case SSL_ERROR_WANT_WRITE:
	case SSL_ERROR_WANT_X509_LOOKUP:
	case SSL_ERROR_ZERO_RETURN:
		return;
		/* These seem to be indications of a genuine error that should
		 * result in the SSL tunnel being regarded as "dead". */
	case SSL_ERROR_SYSCALL:
	case SSL_ERROR_SSL:
		SSL_set_app_data(s, (char *)1);
		return;
	default:
		break;
	}
	printf("Unknown Error ..... %d\n", e);
	abort();
}

SSL_CTX *init_tls_ctx( char *keyfile, char *password)
{
    SSL_METHOD *meth;
    SSL_CTX *ctx;
    
    /* Global system initialization*/
    SSL_library_init();
    SSL_load_error_strings();

    /* An error write context */
    if(!bio_err){
      bio_err = BIO_new_fp(stderr, BIO_NOCLOSE);
    }

    /* Create our context*/
    meth = TLSv1_method();
    ctx = SSL_CTX_new(meth);

    /* Load our keys and certificates*/
    if(!(SSL_CTX_use_certificate_file(ctx, keyfile, SSL_FILETYPE_PEM)))
      berr_exit("Couldn't read certificate file");

    /* Here----The default Callback(which prompts the user via the terminal)
    is replaced with one that simply returns hardwired password */
    SSL_CTX_set_default_passwd_cb(ctx, password_cb);
    if(!(SSL_CTX_use_PrivateKey_file(ctx, keyfile, SSL_FILETYPE_PEM)))
      berr_exit("Couldn't read key file");

   SSL_CTX_set_info_callback(ctx, cb_ssl_info);
   //SSL_CTX_set_verify(ctx, verify_mode, cb_ssl_verify);

    /* Load the CAs we trust*/
    if(!(SSL_CTX_load_verify_locations(ctx, CA_LIST, 0)))
      berr_exit("Couldn't read CA list");
    SSL_CTX_set_verify_depth(ctx, 1);

    /* Load randomness */
    if(!(RAND_load_file(RANDOM, 1024*1024)))
      berr_exit("Couldn't load randomness");
       
    return ctx;
}
      
int new_tls_connection(tls_stuff_t *tstuff, session_t **ssn)
{
	SSL *new_tls = NULL;

	if((new_tls = SSL_new(tstuff->tls_ctx)) == NULL) {
		fprintf(stderr, "Error creating new SSL\n");
		ERR_print_errors_fp(stderr);
		return 0;
	}
	
	/*
	 * We use the SSL's "app_data" to indicate a call-back
	 */
	SSL_set_app_data(new_tls, NULL);

	if (*ssn) {
		close_session(*ssn);
		free(*ssn);
		*ssn = NULL;
	}

	*ssn = (session_t *)malloc(sizeof(session_t));
	(*ssn)->clean_in.used = 0;
	(*ssn)->clean_out.used = 0;
	(*ssn)->dirty_in.used = 0;
	(*ssn)->dirty_out.used = 0;
	(*ssn)->ssl = new_tls;

	/*
	 * Add the message callback to identify what type of message/handshake is passed
	 */
	SSL_set_msg_callback(new_tls, msg_cb);
	SSL_set_msg_callback_arg(new_tls, (*ssn));

	/*
	 * Create & hook up the BIOs to handle the dirty side of the SSL
	 */
	(*ssn)->into_ssl = BIO_new(BIO_s_mem());
	(*ssn)->from_ssl = BIO_new(BIO_s_mem());
	SSL_set_bio((*ssn)->ssl, (*ssn)->into_ssl, (*ssn)->from_ssl);

	/*
	 * At the beginning of a new handshake, SSL explicitly needs to set this.
	 * I am the Client, so I connect
	 */
	SSL_set_connect_state((*ssn)->ssl);

	/*
	 * TLS connection initialization is over
	 * Now handle TLS related hanshaking or Data
	 */
	tls_write(*ssn);
	return 1;
}

int tls_write(session_t *ssn)
{
	int bytes;

	SSL_write(ssn->ssl, ssn->clean_in.data, ssn->clean_in.used);
	bytes = BIO_read(ssn->from_ssl, ssn->dirty_out.data, MAX_RECORD_SIZE);
	if (bytes > 0) {
		ssn->dirty_out.used = bytes;
	} else {
		printf("BIO READ ERROR - %d\n", bytes);
	}
        return 1;
}

/*
 * If client is receiving data from the server
 */
int tls_read(session_t *ssn)
{
	char *myrec;
	int bytes;

	BIO_write(ssn->into_ssl, ssn->dirty_in.data, ssn->dirty_in.used);
	bytes = SSL_read(ssn->ssl, ssn->clean_out.data, MAX_RECORD_SIZE);
	if (bytes > 0) {
		/* Cleaned data */
		ssn->clean_out.used = bytes;

		myrec = (char *)(&(ssn->clean_out.data));
		myrec[ssn->clean_out.used] = '\0';
		printf("The data is - %s .\n", myrec);
		ssn->clean_out.used = 0;
	} else {
		printf("SSL READ NO DATA --- %d\n", bytes);
		int_ssl_check(ssn->ssl, bytes);
		bytes = BIO_read(ssn->from_ssl, ssn->dirty_out.data, MAX_RECORD_SIZE);
		if (bytes > 0) {
			ssn->dirty_out.used = bytes;
		} else {
			printf("BIO READ ERROR - %d\n", bytes);
		}
	}
	memset(ssn->dirty_in.data, 0, ssn->dirty_in.used);
	ssn->dirty_in.used = 0;
	return 1;
}

unsigned int from_record(record_t *rec, unsigned char *ptr,
		unsigned int size)
{
	unsigned int taken = rec->used;

	if(taken > size)
		taken = size;
	if(taken == 0)
		return 0;
	if(ptr)
		memcpy(ptr, rec->data, taken);
	rec->used -= taken;

	if(rec->used > 0)
		memmove(rec->data, rec->data + taken, rec->used);
	return taken;
}

void close_session(session_t *ssn)
{
	if(ssn->ssl)
		SSL_free(ssn->ssl);
	ssn->ssl = NULL;
	ssn->into_ssl = ssn->from_ssl = NULL;

	ssn->clean_in.used = 0;
	ssn->clean_out.used = 0;
	ssn->dirty_in.used = 0;
	ssn->dirty_out.used = 0;
}
