#!/usr/bin/perl
########################################################################
#                                                                      #
#    Version 1.1-Terran                                                #
#                                                                      #
#    Allows users to view their login usage via a web page             #
#                                                                      #
#    radius.cgi          InnerCite                                     # 
#                        Mike Machado <mike@innercite.com>             #
#                        14 May 1999                                   #
#                        Modified by MikeVince <mikevince@yahoo.com>   #
#                        January 2000                                  #
#                                                                      #
#    Web administration for ICRADIUS                                   #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
#                                                                      #
########################################################################

use DBI;
use strict;
use CGI;

use Authen::Radius;	#Uncomment for authtype 1 below

my ($sth);
my $dbusername = 'root';
my $dbpassword = 'mysqlroot';
my $authtype = 1;					# 0 = local lookup; 1 = RADIUS authentication
my $sessionfile = '/usr/local/apache/cgi-bin/radsess';	# session file (needs to be read/writeable by web server)
my $cookiedomain = '.innercite.com';			# Domain of your web server (with a '.' in front)
my $cookieexpire = '+30h';				# Time until their session expires
my $sessexpire = 180;					# Session timeout in seconds
my $tmpdir = '/tmp';					# Temp directory
my $radhost = 'radius1.domain.com';			# Hostname of radius server
my $radsecret = 'testsecret';				# RADIUS secret for this server
my $allow_changepass = 0;				# Allow users to change their password (only works with clear text passwords)

my $body = "<body bgcolor=FFFFFF>";



######### Do not change anything below this line ############

my $dbh = DBI->connect("DBI:mysql:radius", $dbusername, $dbpassword);
my $printheader = 1;
my $query = new CGI;
my $cgi = $query->url();
my $now = getdatetime();
my $printmainpage = 1;

my $version = '0.14';
my $total = 0;
my $i = 0;

if ($query->param('login') eq '') {
	checksession();
}

if ($query->param('login') ne '') {

   my $username = $query->param('username');
   my $password = $query->param('password');

   if (!checkuserpass($username, $password)) {
      error('invalid');
   }
 
   my @alpha = ('A'..'Z', 'a'..'z', 0..9);
   my $sessid = '';
   for (my $i = 0; $i < 10; $i++) {
       $sessid .= @alpha[rand(@alpha)];
   }
 
   my $cookie1 = $query->cookie(-name=>'username',
                                -value=>$username,
                                -expires=>$cookieexpire,
                                -domain=>$cookiedomain);
 
   my $cookie2 = $query->cookie(-name=>'ic_user_sessionid',
                                -value=>$sessid,
                                -expires=>$cookieexpire,
                                -domain=>$cookiedomain);
 
   my $now = time();
   open(NEWSESS, ">>$sessionfile") || error('open');
   print NEWSESS "$username $sessid $now\n";
   close(NEWSESS);
 
   print $query->header(-COOKIE=>[$cookie1, $cookie2]);
   $printheader = 0;

  print "<html><head><title>ICRADIUS $version Radius Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS $version Radius Web Interface</h2>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<input type=hidden name=username value=\"".$query->param('username')."\">\n";
  print "<input type=hidden name=password value=\"".$query->param('password')."\">\n";
  print "<table>";
  print "<tr><td>Select Year and Month</td><td><select name=year>\n";
  print "<option>1999\n";
  print "<option>2000\n";
  print "<option>2001\n";
  print "<option>2002\n";
  print "</select><select name=month>\n";
  print "<option value=\"01\">January\n";
  print "<option value=\"02\">Feburary\n";
  print "<option value=\"03\">March\n";
  print "<option value=\"04\">April\n";
  print "<option value=\"05\">May\n";
  print "<option value=\"06\">June\n";
  print "<option value=\"07\">July\n";
  print "<option value=\"08\">August\n";
  print "<option value=\"09\">September\n";
  print "<option value=\"10\">October\n";
  print "<option value=\"11\">November\n";
  print "<option value=\"12\">December\n";
  print "</select></td></tr>\n";
  print "<tr><td>Report</td><td>Summary <input type=radio name=report value=\"summary\" CHECKED>\&nbsp\;Detailed<input type=radio name=\"report\" value=\"detailed\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"summaryreport\" value=\"Get Report\"><br><br></form>\n";

  if ($allow_changepass) {
    print "<form name=formm action=\"$cgi\" method=post>";
    print "<div align=center>";
    print "<input type=hidden name=passwd value=\"cpass\">";
    print "<input type=hidden name=username value=\"".$query->param('username')."\">\n";
    print "<input type=hidden name=password value=\"".$query->param('password')."\">\n";
    print "<input type=submit name=\"Submit\" value=\"Change Password\">";
    print "</div>";
    print "</form>";
  }

  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;

}

if ($query->param('passwd') eq 'cpass') {

  printheader();
  error('nochangepass') unless $allow_changepass;
  print "<html><head><title>ICRADIUS $version Radius Web Interface</title></head>$body\n";
  print "<center><h2>Change My Password</h2>\n";

  print "<form name=formm action=\"$cgi\" method=post>";
  print "<div align=center>";
  print "<table>";
  print "<input type=hidden name=passwd value=\"docpass\">";
  print "<input type=hidden name=username value=\"".$query->param('username')."\">\n";
  print "<input type=hidden name=password value=\"".$query->param('password')."\">\n";
  print "<tr><td>Old Password :</td><td><input type=password name=pass value=\"\"></td></tr>";
  print "<tr><td>New Password :</td><td><input type=password name=pass1 value=\"\"></td></tr>";
  print "<tr><td>Confirm Password :</td><td><input type=password name=pass2 value=\"\"></td></tr></table><br>";
  print "<input type=submit name=\"Submit\" value=\"Do Something!\">";
  print "</div>";
  print "</form>";

#  print $query->param('username');
#  print $query->param('password');
  print "</center></body></html>";
  $printmainpage = 0;
}

elsif ($query->param('passwd') eq 'docpass') {

  printheader();
  error('nochangepass') unless $allow_changepass;
  error('badold') if !auth($query->param('username'), $query->param('pass'));
  error('blanknew') if ( $query->param('pass1') eq '' ); 
  error('badnew') if ( $query->param('pass1') ne $query->param('pass2')); 
  error('samenew') if ( $query->param('pass') eq $query->param('pass1')); 
  my $sth = $dbh->do("UPDATE radcheck SET Value = \"".$query->param('pass1')."\" WHERE Attribute = \"Password\" and UserName = \"".$query->param('username')."\"");
#  $sth->execute || print "error was ".$dbh->errstr;;
#  my $result = $authsth->fetchrow_array;
  print "<html><head><title>ICRADIUS $version Radius Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS $version Radius Web Interface</h2>\n";
  print "<h3> password changed </h3><br><br>";

  print "<a href=\"$cgi\">Back to Main Page</a>\n";
  print "</center></body></html>";
  $printmainpage = 0;
}

elsif ($query->param('report') eq 'detailed') {


  printheader();
  print "<html><head><title>ICRADIUS $version Radius Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS $version Radius Web Interface</h2>\n";
  print "<br>Detailed report for user '".$query->param('username')."':<br><br>\n";
  my $from = $query->param('year').'-'.$query->param('month').'-01 00:00:00';
  print "Results for ".$query->param('month')."-".$query->param('year')."<br><br>\n";
  print "<center><table border =1>\n";
  print "<tr><th>IP Address</th><th>Start Time</th><th>Stop Time</th><th>Time Used</th></tr>\n";
  my ($sql, $sumsth);
  
      $sql = "SELECT AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStartTime >= \"$from\" AND AcctStopTime <= DATE_ADD('$from', INTERVAL 1 MONTH) AND AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     my $total = 0;
     my $printused;
     my $i;
     while (my @sessiondata = $sumsth->fetchrow_array) {
        $i++;
        $printused = formatseconds($sessiondata[3]);
        print "<tr align=center><td>$sessiondata[2]</td><td>$sessiondata[0]</td><td>$sessiondata[1]</td><td>$printused</td></tr>\n";
        $total += $sessiondata[3];
     }
  print "</table><br><br>\n";
  my $printtotal = formatseconds($total); 
  print "Total Hours: $printtotal<br>\n";
  print "Total Sessions: $i<br><br><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a>\n";



} elsif ($query->param('report') eq 'summary') {


  printheader();
  print "<html><head><title>ICRADIUS $version Radius Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS $version Radius Web Interface</h2>\n";
  print "<br>Summary report for user '".$query->param('username')."':<br><br>\n";
  my $from = $query->param('year').'-'.$query->param('month').'-01 00:00:00';
  print "Results for ".$query->param('month')."-".$query->param('year')."<br><br>\n";
  print "<center><table border=1>\n";
  print "<tr><th>Total Sessions</th><th>Total Hours Used</th></tr>\n";
  my ($sql, $sumsth, $sum);
  
        $sql = "SELECT COUNT(*), SUM(AcctSessionTime) / 3600 FROM radacct WHERE AcctStartTime >= \"$from\" and AcctStopTime <= DATE_ADD('$from', INTERVAL 1 MONTH) and AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     while (my ($sessions, $sum) = $sumsth->fetchrow_array) {
       print "<tr align=center><td>$sessions</a></td><td>$sum</td></tr>\n";
     }
  print "</table><br><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a>\n";

} elsif ($printmainpage) {

  printlogin();
}

sub printlogin {

  my $ip = $ENV{'REMOTE_ADDR'};
  $sth = $dbh->prepare("SELECT UserName FROM radacct where FramedIPAddress = \"$ip\" AND AcctStopTime = 0");
  $sth->execute;
  my $user = $sth->fetchrow_array;

  print "<html><head><title>ICRADIUS $version Radius Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS $version Radius Web Interface</h2>\n";
  print "<br>Enter your login information:<br>\n";
  print "<form action=\"$cgi\" method=post>\n";
  print "<table>\n";
  print "<tr><td>UserName</td><td></td><td><input type=text name=username value=\"$user\"></td></tr>\n";
  print "<tr><td>Password</td><td></td><td><input type=password name=password></td></tr>\n";
  print "<tr><td></td><td></td><td><input type=submit name=login value=\"Go\"></td></tr>\n";
  print "</table>\n";
  print "<p>If you receive an ERROR message, please be sure that the<BR>UserName and password you just typed in is the same as  <BR> the one used to access the internet.</center>\n";

}
 

sub getdatetime {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);
  my @datemonths = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

  my $numidx = "01";
  my ($nummon);
  foreach my $mons (@datemonths) {
    if ($mon eq $mons) {
     $nummon = $numidx;
    }
    $numidx++;
  }

  return "$year-$nummon-$dayofmon $time";

}

sub formatseconds {

my $seconds = shift;
my $hours = 0;
my $minutes = 0;
my $ret = '';

while ($seconds >= 3600) {
 $seconds -= 3600;
 $hours += 1;
}

while ($seconds >= 60) {
 $seconds -= 60;
 $minutes += 1;
}
 $ret = "$hours"."h:" if $hours ne 0;

 $ret .= "$minutes"."m:".$seconds."s";
 return $ret;


}


sub error {

  my $error = shift;

   printheader();
   if ($error eq 'invalid') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1>\n";
     print "<font face=arial>You have entered an invalid username and password combination.</font>\n";
     print "<br><font face=arial>Please try again.\n";
     print "<br><font face=arial>If the problem persists, contact the SysAdmin.</font>\n";
     print "<form name=form1 action=usage.cgi >";
     print "<div align=center>";
     print "<input type=submit name=Submit value='Try Again'>";
     print "</div>";
     print "</form>";
     print "</body></html>\n";
   }
   elsif ($error eq 'badold' || $error eq 'samenew' || $error eq 'blanknew' || $error eq 'badnew' ) {
     my $message = "Your Old Password does not authenticate.";
     print "<html><head><title>Error Changing Your Password</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1>\n";
     if ( $error eq 'blanknew' ) {
     $message = "The admin does not want you to set blank password." } 
     elsif ( $error eq 'badnew' ) {
     $message = "The new password you entered does not matched." }
     elsif ( $error eq 'samenew' ) {
     $message = "The new password you entered is the same as the old one." }
     print "<font face=arial>$message</font>\n";
     print "<br><font face=arial>Please try again.\n";
     print "<br><font face=arial>If the problem persists, contact the SysAdmin.</font>\n";
     print "<br><br><i><b>When in darkness, when in doubt, run in circles, scream and shout.</b></i></center>\n";
     print "<form name=form2 action=\"$cgi\" method=post>";
     print "<div align=center>";
     print "<input type=hidden name=passwd value=\"cpass\">";
     print "<input type=hidden name=username value=\"".$query->param('username')."\">\n";
     print "<input type=hidden name=password value=\"".$query->param('password')."\">\n";
     print "<input type=submit name=Submit value='Try Again'>";
     print "</div>";
     print "</form>";
     print "</body></html>\n";
   } elsif ($error eq 'nochangepass') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1>\n";
     print "<font face=arial>Password changes have been disabled.</font>\n";
     print "</body></html>\n";
  } elsif ($error eq 'sess_expired') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1>\n";
     print "<font face=arial>Session Expired. Please <a href='$cgi'>login</a> again.</font>\n";
     print "</body></html>\n";
  } elsif ($error eq 'open') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1>\n";
     print "<font face=arial>Error opening file. Please contact your administrator.</font>\n";
     print "</body></html>\n";
  }

   exit;

}

#verify user can access administration
sub checksession {
 
  my $username = $query->cookie(-name=>'username');
  my $sessionid = $query->cookie(-name=>'ic_user_sessionid');
 
  if ($sessionid eq '') {
     printheader();
     if ($query->param()) {
        error('sess_expired');
     } else {
        printlogin();
        exit;
    }
  }
 
  my $now = time();
  my $founduser = 0;
  open(SESSFILE, "$sessionfile") || error('open');
  error('open') if -l "$tmpdir/radsess.$$";
  open(NEWSESS, ">$tmpdir/radsess.$$") || error('open');
  while (<SESSFILE>) {
        chomp();
        my ($user, $sess, $time) = split(/\s+/);
        next if $now - $sessexpire > $time;
        if ($username eq $user && !$founduser) {
                if ($sess eq $sessionid) {
                        $founduser = 1;
                        print NEWSESS "$user $sess $now\n";
                        next;
                }
        }
        print NEWSESS "$user $sess $time\n";
  }
  close(SESSFILE);
  close(NEWSESS);
  system("mv $tmpdir/radsess.$$ $sessionfile");
  error('sess_expired') unless $founduser;
 
  my $cookie1 = $query->cookie(-name=>'username',
                                -value=>$username,
                                -expires=>$cookieexpire,
                                -domain=>$cookiedomain);
 
  my $cookie2 = $query->cookie(-name=>'ic_user_sessionid',
                                -value=>$sessionid,
                                -expires=>$cookieexpire,
                                -domain=>$cookiedomain);
 
  print $query->header(-COOKIE=>[$cookie1, $cookie2]);

  $printheader = 0;
 
  return 0;
}


# checks the username and pass against the database
sub checkuserpass {
 
  my $username = shift;
  my $password = shift;
 
  if ($authtype eq 0) {
        # LOCAL Auth
        $sth = $dbh->prepare("SELECT id FROM radcheck WHERE UserName = \"$username\" AND Attribute = \"Password\" AND Value = \"$password\"");
        $sth->execute;
        my $authed = $sth->fetchrow_array;
	return 1 if $authed;
 
  } elsif ($authtype eq 1) {
        # Do RADIUS query and look for Radius-Operator
        my $r = new Authen::Radius(Host => $radhost, Secret => $radsecret);
        my $authed = $r->check_pwd($username, $password);
        return 1 if $authed;
 
  }
 
  return 0;
}

sub printheader {
 
	print "Content-Type: text/html\n\n" if $printheader;
	$printheader = 1;
}
