#
# Makefile	RADIUS - 
#		Remote Authentication Dial In User Service
#
#

RADIUS_DIR = /etc/raddb

SERVER_OBJS    = radiusd.o dict.o files.o filters.o util.o md5.o attrprint.o \
			acct.o radius.o pam.o log.o version.o proxy.o \
			exec.o auth.o mysql.o timestr.o cache.o sql_module.o
SERVERDBM_OBJS = radiusd.o dict.o filesdbm.o filters.o util.o md5.o \
			attrprint.o acct.o radius.o pam.o log.o versiondbm.o \
			proxy.o exec.o auth.o mysql.o timestr.o cache.o
SERVER_SRCS    = radiusd.c dict.c files.c filters.c util.c md5.c attrprint.c \
			acct.c radius.c pam.c log.c version.c proxy.c \
			exec.c auth.c mysql.c timestr.c cache.c sql_module.c
INCLUDES       = radius.h conf.h sql_module.h radiusd.h sysdep.h md5.h cache.h

all:	radiusd

dbm:	radiusd.dbm builddbm

radiusd: $(SERVER_OBJS)
	$(CC) $(LDFLAGS) -o radiusd $(SERVER_OBJS) $(LIBS) $(LCRYPT) $(PAMLIB)

radiusd.dbm: $(SERVERDBM_OBJS)
	$(CC) $(LDFLAGS) -o radiusd.dbm $(SERVERDBM_OBJS) $(LIBS) $(LCRYPT) \
			 $(DBMLIB) $(PAMLIB)

radiusd.o: radiusd.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c radiusd.c

acct.o: acct.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c acct.c

attrprint.o: attrprint.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c attrprint.c

dict.o: dict.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c dict.c

files.o: files.c $(INCLUDES)
	$(CC) $(CFLAGS) $(PAM) $(ASCEND_FLAGS) -c files.c

filters.o: filters.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c filters.c

radius.o: radius.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) $(ASCEND_SECRETS) -c radius.c

util.o: util.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c util.c

pam.o:  pam.c $(INCLUDES)
	$(CC) $(CFLAGS) $(PAM) -c pam.c

cache.o:  cache.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c cache.c

mysql.o:  mysql.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c mysql.c

sql_module.o:  sql_module.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c sql_module.c

proxy.o:  proxy.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c proxy.c

exec.o:  exec.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -c exec.c

auth.o:  auth.c $(INCLUDES)
	$(CC) $(CFLAGS) $(PAM) $(ASCEND_FLAGS) -c auth.c

version.o: version.c $(INCLUDES)
	$(CC) $(CFLAGS) $(ASCEND_FLAGS) -o version.o -c version.c

md5.o: md5.c md5.h
	$(CC) $(CFLAGS) -c md5.c

lint:
	-lint -hbacvx -DLINT $(SERVER_SRCS)
	-lint -hbacvx -DLINT ../radpass.c ../md5.c ../util.c

clean:
	rm -f *.o radiusd
	rm -f ../build ../debian/substvars ../debian/files

install:
	# Install the binaries
	install -d $(SBINDIR)
	install -d $(BINDIR)
	install -d $(RADIUS_DIR)
	install -m 755 -s radiusd $(SBINDIR)/radiusd
	install -m 755    checkrad.pl $(SBINDIR)/checkrad
	# Install the config files
	@echo "Creating/updating files in $(RADIUS_DIR)"; \
	cd ../raddb; \
	[ ! -f $(RADIUS_DIR)/radius.conf ] && cp radius.conf $(RADIUS_DIR)/radius.conf; \
