#!/usr/bin/perl
########################################################################
#                                                                      #
#    radius.cgi                   Mike Machado <mike@innercite.com>    #
#                                 27 April 1999                        #
#                                                                      #
#    Web CGI to administer your RADIUS authentication and accounting   #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
########################################################################

use DBI;
use strict;
use CGI;


my ($sth);
my $dbh = DBI->connect("DBI:mysql:radius", "root");

my $query = new CGI;
my $cgi = $query->url();
my $now = getdatetime();
my $printmainpage = 1;

my $body = "<body bgcolor=dddddd>";
my $total = 0;
my $i = 0;
my $DAYSPERMON = 30;

print "Content-type: text/html\n\n";

if ($query->param('action') eq 'summary') {

  checksession('user'); 
  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Enter date ranges below. Leave blank for a complete total.<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table>";
  print "<tr><td>From Time</td><td><input type=text name=from value=\"\"></td></tr>\n";
  print "<tr><td>To Time</td><td><input type=text name=to value=\"$now\"></td></tr>\n";
  print "<tr><td>Sort By</td><td><select name=orderby>\n";
  print "<option value=\"UserName\">UserName\n";
  print "<option value=\"s\">Hours Used\n";
  print "</select> Acending<input type=radio name=\"direction\" value=\"ASC\" CHECKED>\&nbsp\;\&nbsp\;Decending<input type=radio name=\"direction\" value=\"DESC\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"summaryreport\" value=\"Get Report\"><br>\n";

  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'utilization') {

  checksession('user'); 
  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Enter a date below to get a graph of portmaster usage. Leave blank to get current usage.<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table>";
  print "<tr><td>Time</td><td><input type=text name=time value=\"\"></td></tr>\n";
#  print "<tr><td>To Time</td><td><input type=text name=to value=\"$now\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"utilgraph\" value=\"Get Graph\"><br>\n";

  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'loginstatus' || $query->param('loginstatusreport') ne '') {

  checksession('user'); 
  print "<html><head><title>InnerCite RADIUS Web Interface</title>\n";

  print qq!
  <script language=javascript>

  function resetdate() {
  
    d = new Date();
    m = d.getMonth();
    m++;
    y = d.getFullYear();
    t = d.getTime();
    day = d.getDate();
    h = d.getHours();
    min = d.getMinutes();
    sec = d.getSeconds();
    time = y+"-"+m+"-"+day+" "+h+":"+min+":"+sec;

    document.form1.fromtime.value = time;
    document.form1.totime.value = time;
    document.form1.username.focus();
  }

  function clearboxes() {

    document.form1.username.value = ''
    document.form1.fromtime.value = ''
    document.form1.totime.value = ''
    document.form1.nasip.value = ''
    document.form1.nasport.value = ''
    document.form1.nasporttype.value = ''
    document.form1.framedipaddress.value = ''
//    document.form1.terminatecause.SelectedIndex = 0
    document.form1.username.focus()

  }

  </script>

  !;

  print "</head><body onload=\"document.form1.username.focus()\">\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Leave From and To Time blank to search current logged in users<br>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<br><table>\n";
  my $fromtime = getdatetime() if $query->param('loginstatusreport') eq '';
  $fromtime = $query->param('fromtime') if $query->param('fromtime');
  my $totime = getdatetime() if $query->param('loginstatusreport') eq '';
  $totime = $query->param('totime') if $query->param('totime');
  print "<tr><td>User</td><td><input type=text name=username value=\"".$query->param('username')."\"></td><td width=20></td><td>NAS IP Address</td><td><input type=text name=nasip value=\"".$query->param('nasip')."\"></td></tr>\n";
  print "<tr><td>From Time</td><td><input type=text name=fromtime value=\"$fromtime\"></td><td width=20></td><td>NAS Port</td><td><input type=text name=nasport value=\"".$query->param('nasport')."\"></td></tr>\n";
  print "<tr><td>To Time</td><td><input type=text name=totime value=\"$totime\"></td><td width=20></td><td>NAS Port Type</td><td><input type=text name=nasporttype value=\"".$query->param('nasporttype')."\"></td></tr>\n";
  print "<tr><td>Framed IP Address</td><td><input type=text name=framedipaddress value=\"".$query->param('framedipaddress')."\"></td><td></td><td>Terminate Cause</td><td>";
  print "<select name=terminatecause>\n";
  print "<option selected>".$query->param('terminatecause')."\n";

  my @termcauses = ("","User-Request","Lost-Carrier","Lost-Service","Idle-Timeout","Session-Timeout","Admin-Reset","Admin-Reboot","Port-Error","NAS-Error","NAS-Request","NAS-Reboot","Port-Unneeded","Port-Preempted","Port-Suspended","Service-Unavailable","Callback","User-Error","Host-Request");
  foreach my $cause (@termcauses) {
     next if $cause eq $query->param('terminatecause');
     print "<option>$cause\n";
   }

  print "</select></td></tr>\n";
  print "<tr><td></td><td><input type=submit name=loginstatusreport value=\"Get Report\">\&nbsp\;<input type=button value=\"Clear Form\" onclick=\"clearboxes()\">\&nbsp\;<input type=button value=\"Fill Dates\" onclick=\"resetdate()\"></td><td></td><td></td><td></td></tr>\n";
  print "</table></form>\n";

  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'getrecord') {

  checksession('user'); 
  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<table width=400 border=1>";
  print "<tr align=center><th>Attribute</th><th>Value</th></tr>\n";
  $sth = $dbh->prepare("select * from radacct where RadacctID = \"".$query->param('id')."\"");
  $sth->execute;
  my @recorddata = $sth->fetchrow_array;
  print "<tr><td>Radius-Id</td><td>$recorddata[0]</td></tr>\n";
  print "<tr><td>Acct-Session-Id</td><td>$recorddata[1]</td></tr>\n";
  print "<tr><td>User-Name</td><td>$recorddata[2]</td></tr>\n";
  print "<tr><td>NAS-IP-Address</td><td>$recorddata[3]</td></tr>\n";
  print "<tr><td>NAS-Port-Id</td><td>$recorddata[4]</td></tr>\n";
  print "<tr><td>NAS-Port-Type</td><td>$recorddata[5]</td></tr>\n";
  print "<tr><td>Acct-Start-Time</td><td>$recorddata[6]</td></tr>\n";
  print "<tr><td>Acct-Stop-Time</td><td>$recorddata[7]</td></tr>\n";
  print "<tr><td>Acct-Session-Time</td><td>$recorddata[8]</td></tr>\n";
  print "<tr><td>Acct-Authentic</td><td>$recorddata[9]</td></tr>\n";
  print "<tr><td>Connect-Info</td><td>$recorddata[10]</td></tr>\n";
  print "<tr><td>Acct-Input-Octets</td><td>$recorddata[11]</td></tr>\n";
  print "<tr><td>Acct-Output-Octets</td><td>$recorddata[12]</td></tr>\n";
  print "<tr><td>Called-Station-Id</td><td>$recorddata[13]</td></tr>\n";
  print "<tr><td>Calling-Station-Id</td><td>$recorddata[14]</td></tr>\n";
  print "<tr><td>Acct-Terminate-Cause</td><td>$recorddata[15]</td></tr>\n";
  print "<tr><td>Service-Type</td><td>$recorddata[16]</td></tr>\n";
  print "<tr><td>Framed-Protocol</td><td>$recorddata[17]</td></tr>\n";
  print "<tr><td>Framed-IP-Address</td><td>$recorddata[18]</td></tr>\n";
  print "<tr><td>Acct-Delay-Time</td><td>$recorddata[19]</td></tr>\n";
  print "</table><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'detailed') {

  checksession('user'); 
  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Enter date ranges and username below. Leave dates blank for a complete total.<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table>";
  print "<tr><td>UserName</td><td><input type=text name=username value=\"".$query->param('username')."\"></td></tr>\n";
  print "<tr><td>From Time</td><td><input type=text name=from value=\"\"></td></tr>\n";
  print "<tr><td>To Time</td><td><input type=text name=to value=\"$now\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"detailedreport\" value=\"Get Report\"><br>\n";
  
  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'abuse' || $query->param('abusereport') ne '') {


  my $printlimit = "240";
  $printlimit = $query->param('hours') if $query->param('hours');
  checksession('user'); 
  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<h3>Abuse Report</h3>\n";
  print "<form action=\"$cgi\" method=post>\n";
  print "<table border=0>\n";
  print "<tr><td>Select Year and Month</td><td><select name=year>\n";
  print "<option>1999\n";
  print "<option>2000\n";
  print "<option>2001\n";
  print "<option>2002\n";
  print "</select><select name=month>\n";
  print "<option value=\"01\">January\n";
  print "<option value=\"02\">Feburary\n";
  print "<option value=\"03\">March\n";
  print "<option value=\"04\">April\n";
  print "<option value=\"05\">May\n";
  print "<option value=\"06\">June\n";
  print "<option value=\"07\">July\n";
  print "<option value=\"08\">August\n";
  print "<option value=\"09\">September\n";
  print "<option value=\"10\">October\n";
  print "<option value=\"11\">November\n";
  print "<option value=\"12\">December\n";
  print "</select></td></tr>\n";
  print "<tr><td>Enter limit in hours</td><td><input type=text name=hours value=\"$printlimit\" size=5></td></tr>\n";
  print "<tr><td></td><td><input type=submit name=abusereport value=\"Get Report\"></td></tr>\n";
  print "</table><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a><br><br>\n";

  $printmainpage = 0;
}


if ($query->param('loginstatusreport') ne '') {

  my $custdbh = DBI->connect("DBI:mysql:custdb","root");

  print "<br><br><center><table border =1>\n";
  my $sql;

    
    print "<tr><th>UserName</th><th>IP Address</th><th>Start Time</th><th>Stop Time</th><th>Time Used</th></tr>\n";

    if ($query->param('fromtime') eq '' && $query->param('totime') eq '') {
       $sql = "SELECT UserName, FramedIPAddress, AcctStartTime, AcctStopTime, AcctSessionTime, RadacctID FROM radacct WHERE AcctStopTime = 0";
    } else {
       $sql = "SELECT UserName, FramedIPAddress, AcctStartTime, AcctStopTime, AcctSessionTime, RadacctID FROM radacct WHERE \(AcctStopTime >= \"".$query->param('fromtime')."\" AND AcctStartTime <= \"".$query->param('totime')."\"\)";
    }


    $sql .= " AND UserName = \"".$query->param('username')."\"" if $query->param('username');
    $sql .= " AND NASIPAddress = \"".$query->param('nasip')."\"" if $query->param('nasip');
    $sql .= " AND NASPortId = \"".$query->param('nasport')."\"" if $query->param('nasport');
    $sql .= " AND NASPortType = \"".$query->param('nasporttype')."\"" if $query->param('nasporttype');
    $sql .= " AND FramedIPAddress = \"".$query->param('framedipaddress')."\"" if $query->param('framedipaddress');
    $sql .= " AND AcctTerminateCause = \"".$query->param('terminatecause')."\"" if $query->param('terminatecause');
  
    $sql .= " ORDER BY UserName";

    $sth = $dbh->prepare($sql);
  #  print "SQL: $sql<br>\n";
    $sth->execute || print "error was ". $dbh->errstr;
    my $timeused;
    my $secused;
    my $timesth;
    my $stoptimedisplay;
    while (my @sessiondata = $sth->fetchrow_array) {
       $i++;
       if ($sessiondata[4] eq '0') {
         $timesth = $dbh->prepare("SELECT UNIX_TIMESTAMP\(NOW\(\)\) - UNIX_TIMESTAMP\(\"$sessiondata[2]\"\)");
         $timesth->execute;
         $secused = $timesth->fetchrow_array;
         $timeused = formatseconds($secused);
         $total += $secused;
       } else {
         $timeused = formatseconds($sessiondata[4]);
         $total += $sessiondata[4];
       }
       $stoptimedisplay = $sessiondata[3];
       $stoptimedisplay = "Currently Logged On" if $sessiondata[3] eq '0000-00-00 00:00:00';
       print "<tr><td><a href=\"$cgi\?action=getrecord\&id=$sessiondata[5]\">$sessiondata[0]</a></td><td>$sessiondata[1]</td><td>$sessiondata[2]</td><td>$stoptimedisplay</td><td>$timeused</td></tr>\n";

    }

  my $realtotal = formatseconds($total);
  print "</table>\n";
  print "<br>Total Sessions: $i<br>\n";
  print "Total Usage: $realtotal<br>\n";



} elsif ($query->param('detailedreport') ne '') {

  checksession('user'); 

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Detailed report for user '".$query->param('username')."':<br>\n";
  my $from = 'Any';
  my $to = 'Any';
  $from = $query->param('from') if $query->param('from');
  $to = $query->param('to') if $query->param('to');
  print "From: $from\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;To: $to<br><br>\n";
  print "<center><table border =1>\n";
  print "<tr><th>UserName</th><th>IP Address</th><th>Start Time</th><th>Stop Time</th><th>Time Used</th></tr>\n";
  my ($sql, $sumsth);
  
     if ($query->param('from') ne '' && $query->param('to') ne '') {


        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" AND AcctStopTime <= \"".$query->param('to')."\" AND AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     } elsif ($query->param('from') ne '') {

        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" AND UserName = \"".$query->param('username')."\"";

     } elsif ($query->param('to') ne '') {

        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStopTime <= \"".$query->param('to')."\" AND AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     } else {

        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE UserName = \"".$query->param('username')."\"";
     }

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     my $total = 0;
     my $printused;
     while (my @sessiondata = $sumsth->fetchrow_array) {
        $printused = formatseconds($sessiondata[5]);
        print "<tr align=center><td><a href=\"$cgi\?action=getrecord\&id=$sessiondata[1]\">$sessiondata[0]</a></td><td>$sessiondata[4]</td><td>$sessiondata[2]</td><td>$sessiondata[3]</td><td>$printused</td></tr>\n";
        $total += $sessiondata[5];
     }
  print "</table><br>\n";
  my $printtotal = formatseconds($total); 
  print "Total: $printtotal<br><br><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a>\n";


} elsif ($query->param('utilgraph') ne '') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head><body bgcolor=ffffff>\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Graph of portmaster usage at ".$query->param('time').":<br><br>\n" if $query->param('time') ne '';
  print "<br>Graph of current portmaster utilization<br><br>\n" if $query->param('time') eq '';
  
 
  print "<center><table>\n";
  print "<tr><th>Portmaster</th><th>Port Utilization</th></tr>\n";
  my $portsused;
  my $imagewidth = 0;

  my $sth1 = $dbh->prepare("SELECT * FROM portmasters ORDER BY id");
  $sth1->execute;
  my ($junk, $rpercent, $percent, $totalports, $totalused, $diff, $displaydiff);
  while (my @pdata = $sth1->fetchrow_array) {

     if ($query->param('time') ne '') {
        $sth = $dbh->prepare("SELECT count\(*\) FROM radacct WHERE \(\(AcctStartTime <= \"".$query->param('time')."\" AND AcctStopTime >= \"".$query->param('time')."\"\) OR \(AcctStartTime <= \"".$query->param('time')."\" AND AcctStopTime = 0\)\) AND NASIPAddress = \"$pdata[1]\"");
     } else {
        $sth = $dbh->prepare("SELECT count\(*\) FROM radacct WHERE AcctStopTime = 0 AND NASIPAddress = \"$pdata[1]\"");
     }
     $sth->execute || print "error was ". $dbh->errstr;
     $portsused = $sth->fetchrow_array;
     $imagewidth = $portsused * 7;
     $rpercent =  $portsused/$pdata[3] * 100;
     ($percent, $junk) = split(/\./, $rpercent);
     $diff = $pdata[3] - $portsused;
     $displaydiff = $diff * 7;
#     print "<tr><td>$pdata[2]</td><td><image src=\"/images/lside2.gif\" height=20><img src=\"/images/mid2.gif\" height=20 width=$imagewidth><img src=\"/images/rside2.gif\" height=20>  $portsused/$pdata[3]   ($percent\%)</td></tr>\n";
     print "<tr><td>$pdata[2]</td><td><image src=\"/images/ltest.gif\" height=20><img src=\"/images/lctest.gif\" height=20 width=$imagewidth><img src=\"/images/rctest.gif\" height=20><img src=\"/images/rtest.gif\" height=20 width=$displaydiff><img src=\"/images/rrtest.gif\" height=20>  $portsused/$pdata[3]   ($percent\%)</td></tr>\n";

    $totalports += $pdata[3];
    $totalused += $portsused;

  } 
  my $totalpercent = $totalused/$totalports * 100;
  ($percent, $junk) = split(/\./, $totalpercent);
  print "</table><br><br>\n";
  print "Available <img src=\"/images/yellow.gif\" width=20 height=20>   Used <img src=\"/images/red.gif\" width=20 height=20>\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;\n";
  print "Total: $totalused/$totalports   ($percent\%)</center>\n";




} elsif ($query->param('summaryreport') ne '') {

  checksession('user'); 

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Summary of all users:<br><br>\n";
  print "<center><table border=1>\n";
  print "<tr><th>UserName</th><th>Hours Used</th></tr>\n";
  my $orderby = 'UserName';
  $orderby = $query->param('orderby') if $query->param('orderby');
  my $direction = $query->param('direction');
  my ($sql, $sumsth, $sum);
  
     if ($query->param('from') ne '' && $query->param('to') ne '') {


        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" and AcctStopTime <= \"".$query->param('to')."\" and AcctStopTime != 0 GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";

     } elsif ($query->param('from') ne '') {

        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";

     } elsif ($query->param('to') ne '') {

        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct WHERE AcctStopTime <= \"".$query->param('to')."\" and AcctStopTime != 0 GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";

     } else {

        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";
     }

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     my $i = 0;
     my $totalsum = 0;
     while (my ($user, $sum) = $sumsth->fetchrow_array) {
        $i++;
        print "<tr align=center><td><a href=\"$cgi\?action=detailed\&username=$user\">$user</a></td><td>$sum</td></tr>\n";
        $totalsum += $sum;
     }
  print "</table><br>\n";
  print "Total number of users: $i<br>\n";
  print "Total number of hours: $totalsum<br>\n";


} elsif ($query->param('abusereport') ne '') {


  checksession('user'); 

  my $from = $query->param('year').'-'.$query->param('month').'-01 00:00:00';
  my $newmonth = $query->param('month') + 1;
  my $to = $query->param('year').'-'.$newmonth.'-01 00:00:00';
  my $limit = $query->param('hours');
  $sth = $dbh->prepare("SELECT UserName, SUM(AcctSessionTime) AS s FROM radacct WHERE AcctStartTime >= \"$from\" AND AcctStopTime <= \"$to\" GROUP BY UserName ORDER BY s DESC");
  $sth->execute;
  my %ABUSER;
  my %SUSPECT;
  my $hours;
  my $avgdaily;
  my $dailylimit;
  my @susdata;
  while (my @data = $sth->fetchrow_array) {

     $hours = $data[1] / 3600;
     if ($hours > $limit) {
        $ABUSER{$data[0]} = $hours;
     }
     next if $ABUSER{$data[0]};

     $avgdaily = $hours / getdayofmon();
     $dailylimit = $limit / $DAYSPERMON;
     if ($avgdaily > $dailylimit) {
        $SUSPECT{$data[0]} = newarry($avgdaily, $hours);
     }
     
  }
  print "Abusers over $limit hours<br><br>\n";
  print "<table border=1>\n";
  print "<tr><th>UserName</th><th>Hours Used</th></tr>\n";
  my ($printhours, $junk);
  foreach my $user (sort(keys %ABUSER)) {
    ($printhours, $junk) = split(/\./, $ABUSER{$user});
    print "<tr align=center><td>$user</td><td>$printhours</td></tr>\n";
  }
  print "</table>\n";


  print "<br><br>Users projected to go over $limit hours<br><br>\n";
  print "<table border=1>\n";
  print "<tr><th>UserName</th><th>Average Hours<br>Per Day</th><th>Projected Use<br>This Month</th><th>Hours Used<br>So Far</th></tr>\n";
  my ($printhours, $junk);
  my @suspects;
  foreach my $user (sort(keys %SUSPECT)) {
    @suspects = @{$SUSPECT{$user}};
    print "<tr align=center><td>$user</td><td>$suspects[0]</td><td>$suspects[1]</td><td>$suspects[2]</td></tr>\n";
  }
  print "</table>\n";


} elsif ($printmainpage) {

  checksession('user'); 

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Choose Report:<br>\n";
  print "<ul>\n";
  print "<li><a href=\"$cgi\?action=summary\">Usage Summary</a><br>\n";
  print "<li><a href=\"$cgi\?action=detailed\">Detailed by User</a><br>\n";
  print "<li><a href=\"$cgi\?action=loginstatus\">Login Report</a><br>\n";
  print "<li><a href=\"$cgi\?action=abuse\">Abuse Report</a><br>\n";
  print "<br><br>Choose Graph:<br><br>\n";
  print "<li><a href=\"$cgi\?action=utilization\">Utilization Graph</a><br><br>\n";
  
  print "<a href=\"$custdbcgi\">Back to Customer Database</a>\n";

}

sub getdatetime {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);
  my @datemonths = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

  my $numidx = "01";
  my ($nummon);
  foreach my $mons (@datemonths) {
    if ($mon eq $mons) {
     $nummon = $numidx;
    }
    $numidx++;
  }

  return "$year-$nummon-$dayofmon $time";

}

sub formatseconds {

my $seconds = shift;
my $hours = 0;
my $minutes = 0;
my $ret = '';

while ($seconds >= 3600) {
 $seconds -= 3600;
 $hours += 1;
}

while ($seconds >= 60) {
 $seconds -= 60;
 $minutes += 1;
}
 $ret = "$hours"."h:" if $hours ne 0;

 $ret .= "$minutes"."m:".$seconds."s";
 return $ret;


}


sub error {

  my $error = shift;

   if ($error eq 'not_admin') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>You are not marked as a system administrator.</font>\n";
     print "<br><font face=arial>Please login again <a href=\"$cgi\?go=login\" target=\"_top\">HERE</a> if you think this is an error.</font>\n";
     print "</body></html>\n";
   } elsif ($error eq 'expired') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>Your session has timed out for security reasons.</font>\n";
     print "<br><font face=arial>Please login again <a href=\"$custdbcgi\?go=login\" target=\"_top\">HERE</a>\n";
     print "</font></body></html>\n";
   }


   exit;

}


sub getportmasterinfo {

  my $ipaddress = shift;
  my $sth1 = $dbh->prepare("SELECT id, ipaddr, shotname, ports FROM nas WHERE ipaddr = \"$ipaddress\"");
  $sth1->execute;
  return $sth1->fetchrow_arrayref;

}

# Returns the day of the month
sub getdayofmon {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);

  return "$dayofmon";

}

sub newarry {

  my $avg = shift;
  my $used = shift;
  my @stuff;

  ($stuff[0]) = split(/\./,$avg);
  ($stuff[1]) = split(/\./, $avg * $DAYSPERMON);
  ($stuff[2]) = split(/\./,$used);

  return \@stuff;

}
