#!/usr/bin/perl
########################################################################
#                                                                      #
#    syncaccounting.pl            InnerCite                            #
#                                 Mike Machado <mike@innercite.com>    #
#                                 27 April 1999                        #
#                                                                      #
#    Sync accouting records to actual portmaster logins                #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
########################################################################

use DBI;
use strict;
use Getopt::Std;

my $username = "root";
my $password = "rootpass";


my %opts;
getopts('cn:', \%opts);

my $fixdb = 0;
my $nas;
if (exists $opts{'n'}) {
  $nas = $opts{'n'};
}
if (!exists $opts{'c'}) {
  $fixdb = 1;
}


if ($nas eq '') {
  print "Usage: syncaccounting.pl [-c] -n {nasipaddress | ALL}\n";
  exit;
}

my $dbh = DBI->connect("DBI:mysql:radius", $username, $password) || die "Cannot connect to radius database to fix accounting records\n";
my ($sth, $sth1);
my $i = 0;

my $sql;
if ($nas eq 'ALL') {
   if ($fixdb) {
      $sth = $dbh->do("UPDATE radacct SET AcctStartTime =  from_unixtime\(unix_timestamp\(AcctStopTime\) - AcctSessionTime\) WHERE AcctStartTime = 0");
   }
   $sql = "SELECT * FROM radacct WHERE AcctStopTime = 0";
} else {
   if ($fixdb) {
      $sth = $dbh->do("UPDATE radacct SET AcctStartTime =  from_unixtime\(unix_timestamp\(AcctStopTime\) - AcctSessionTime\) WHERE AcctStartTime = 0 AND NASIPAddress = \"$nas\"");
   }
   $sql = "SELECT * FROM radacct WHERE AcctStopTime = 0 AND NASIPAddress = \"$nas\"";
}
$sth = $dbh->prepare($sql);
$sth->execute;
while (my @data = $sth->fetchrow_array) {

  print "Checking NAS $data[3] (port $data[4]) for user $data[2] with sessionid $data[1]\n";
  if (system("checkrad livingston $data[3] $data[4] $data[2] $data[1]")) {
     print "Yes, $data[2] is logged in now\n";
  } else {
     $i++;
     print "No, $data[2] was not logged in\n";
     if ($fixdb) {
        $sth1 = $dbh->do("DELETE FROM radacct WHERE RadAcctId = \"$data[0]\"");
     }
  } 
}
if ($fixdb) {
   print "\n\n  Fixed $i stale records\n";
} else {
   print "\n\n  Found $i stale records\n";
}

$sth->finish;
$dbh->disconnect;
