#!/usr/bin/perl -T
########################################################################
#                                                                      #
#    userexport.pl                InnerCite                            #
#                                 Mike Machado <mike@innercite.com>    #
#                                 13 May 1999                          #
#                                                                      #
#    Dumps ICRADIUS database to standard users file format             #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
#   Note: use userexport.pl -l for old livingston users format         #
#                                                                      #
########################################################################


use DBI;
use strict;

my $dbusername = 'root';
my $dbpassword = 'rootpass';
my $dbh = DBI->connect("DBI:mysql:radius", $dbusername, $dbpassword) || die "Cound not connect to radius database as $dbusername\n";

my $mode = shift;

my $sth = $dbh->prepare("SELECT DISTINCT UserName FROM radcheck ORDER BY UserName");
$sth->execute;
while (my $user = $sth->fetchrow_array) {
  
   my $checkstr = '';
   my $replystr = '';
   print "$user\t";
   my $sth1 = $dbh->prepare("SELECT * FROM radcheck WHERE UserName = \"$user\"");
   $sth1->execute;
   while (my @checks = $sth1->fetchrow_array) {
      # get rid of attribs that livingston radius do not understand
      next if $checks[2] eq 'Simultaneous-Use' && $mode eq '-l';

      next if $checks[2] eq 'Radius-Operator';
      if ($checks[2] eq 'Password') {
         $checkstr .= "$checks[2] = \"$checks[3]\", ";
      } else {
         $checkstr .= "$checks[2] = $checks[3], ";
      }
   }
   my $sth1 = $dbh->prepare("SELECT radgroupcheck.* FROM radgroupcheck, usergroup where usergroup.GroupName = radgroupcheck.GroupName and usergroup.UserName = \"$user\"");
   $sth1->execute;
   while (my @checks = $sth1->fetchrow_array) {
      # get rid of attribs that livingston radius do not understand
      next if $checks[2] eq 'Simultaneous-Use' && $mode eq '-l';

      next if $checks[2] eq 'Radius-Operator' && $mode eq '-l';
      $checkstr .=  "$checks[2] = $checks[3], ";
   }
   $checkstr = substr($checkstr, 0, length($checkstr) - 2);
   print "$checkstr\n";

   my $sth1 = $dbh->prepare("SELECT * FROM radreply WHERE UserName = \"$user\"");
   $sth1->execute;
   while (my @reply = $sth1->fetchrow_array) {
      if ($reply[2] eq 'Framed-Route') {
         $replystr .= "\t$reply[2] = \"$reply[3]\",\n";
      } else {
         $replystr .= "\t$reply[2] = $reply[3],\n";
      }
   }
   my $sth1 = $dbh->prepare("SELECT radgroupreply.* FROM radgroupreply, usergroup where usergroup.GroupName = radgroupreply.GroupName and usergroup.UserName = \"$user\"");
   $sth1->execute;
   while (my @reply = $sth1->fetchrow_array) {
      if ($reply[2] eq 'Framed-Route') {
         $replystr .= "\t$reply[2] = \"$reply[3]\",\n";
      } else {
         $replystr .= "\t$reply[2] = $reply[3],\n";
      }
   }
   $replystr = substr($replystr, 0, length($replystr) - 2);
   print "$replystr\n";

   print "\n";

}

$sth->finish;
$dbh->disconnect;
