#!/usr/bin/perl
########################################################################
#                                                                      #
#    usage.cgi                    InnerCite                            #
#                                 Mike Machado <mike@innercite.com>    #
#                                 05 May 1999                          #
#                                                                      #
#    Allows users to view their login usage via a web page             #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
########################################################################

use DBI;
use strict;
use CGI;


my ($sth);
my $dbusername = 'root';
my $dbpassword = 'rootpass';

my $dbh = DBI->connect("DBI:mysql:radius", $dbusername, $dbpassword);

my $query = new CGI;
my $cgi = $query->url();
my $now = getdatetime();
my $printmainpage = 1;

my $body = "<body bgcolor=dddddd>";
my $total = 0;
my $i = 0;

print "Content-type: text/html\n\n";

if ($query->param('login') ne '') {

  error('invalid') if !auth($query->param('username'), $query->param('password'));

  print "<html><head><title>ICRADIUS Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS Web Interface</h2>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<input type=hidden name=username value=\"".$query->param('username')."\">\n";
  print "<input type=hidden name=password value=\"".$query->param('password')."\">\n";
  print "<table>";
  print "<tr><td>Select Year and Month</td><td><select name=year>\n";
  print "<option>1999\n";
  print "<option>2000\n";
  print "<option>2001\n";
  print "<option>2002\n";
  print "</select><select name=month>\n";
  print "<option value=\"01\">January\n";
  print "<option value=\"02\">Feburary\n";
  print "<option value=\"03\">March\n";
  print "<option value=\"04\">April\n";
  print "<option value=\"05\">May\n";
  print "<option value=\"06\">June\n";
  print "<option value=\"07\">July\n";
  print "<option value=\"08\">August\n";
  print "<option value=\"09\">September\n";
  print "<option value=\"10\">October\n";
  print "<option value=\"11\">November\n";
  print "<option value=\"12\">December\n";
  print "</select></td></tr>\n";
  print "<tr><td>Report</td><td>Summary <input type=radio name=report value=\"summary\" CHECKED>\&nbsp\;Detailed<input type=radio name=\"report\" value=\"detailed\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"summaryreport\" value=\"Get Report\"><br><br>\n";

  print "<a href=\"$cgi\">Back to Main Page</a>\n";

  $printmainpage = 0;

}


if ($query->param('report') eq 'detailed') {


  error('invalid') if !auth($query->param('username'), $query->param('password'));
  print "<html><head><title>ICRADIUS Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS Web Interface</h2>\n";
  print "<br>Detailed report for user '".$query->param('username')."':<br><br>\n";
  my $from = $query->param('year').'-'.$query->param('month').'-01 00:00:00';
  my $newmonth = $query->param('month') + 1;
  my $to = $query->param('year').'-'.$newmonth.'-01 00:00:00';
  print "Results for ".$query->param('month')."-".$query->param('year')."<br><br>\n";
  print "<center><table border =1>\n";
  print "<tr><th>IP Address</th><th>Start Time</th><th>Stop Time</th><th>Time Used</th></tr>\n";
  my ($sql, $sumsth);
  
      $sql = "SELECT AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStartTime >= \"$from\" AND AcctStopTime <= \"$to\" AND AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     my $total = 0;
     my $printused;
     my $i;
     while (my @sessiondata = $sumsth->fetchrow_array) {
        $i++;
        $printused = formatseconds($sessiondata[3]);
        print "<tr align=center><td>$sessiondata[2]</td><td>$sessiondata[0]</td><td>$sessiondata[1]</td><td>$printused</td></tr>\n";
        $total += $sessiondata[3];
     }
  print "</table><br><br>\n";
  my $printtotal = formatseconds($total); 
  print "Total Hours: $printtotal<br>\n";
  print "Total Sessions: $i<br><br><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a>\n";



} elsif ($query->param('report') eq 'summary') {


  error('invalid') if !auth($query->param('username'), $query->param('password'));
  print "<html><head><title>ICRADIUS Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS Web Interface</h2>\n";
  print "<br>Summary report for user '".$query->param('username')."':<br><br>\n";
  my $from = $query->param('year').'-'.$query->param('month').'-01 00:00:00';
  my $newmonth = $query->param('month') + 1;
  my $to = $query->param('year').'-'.$newmonth.'-01 00:00:00';
  print "Results for ".$query->param('month')."-".$query->param('year')."<br><br>\n";
  print "<center><table border=1>\n";
  print "<tr><th>Total Sessions</th><th>Total Hours Used</th></tr>\n";
  my ($sql, $sumsth, $sum);
  
        $sql = "SELECT COUNT(*), SUM(AcctSessionTime) / 3600 FROM radacct WHERE AcctStartTime >= \"$from\" and AcctStopTime <= \"$to\" and AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     while (my ($sessions, $sum) = $sumsth->fetchrow_array) {
        print "<tr align=center><td>$sessions</a></td><td>$sum</td></tr>\n";
     }
  print "</table><br><br>\n";
  print "<a href=\"$cgi\">Back to Main Page</a>\n";

} elsif ($printmainpage) {

  my $ip = $ENV{'REMOTE_ADDR'};
  $sth = $dbh->prepare("SELECT UserName FROM radacct where FramedIPAddress = \"$ip\" AND AcctStopTime = 0");
  $sth->execute;
  my $user = $sth->fetchrow_array;

  print "<html><head><title>ICRADIUS Web Interface</title></head>$body\n";
  print "<center><h2>ICRADIUS Web Interface</h2>\n";
  print "<br>Enter your login information:<br>\n";
  print "<form action=\"$cgi\" method=post>\n";
  print "<table>\n";
  print "<tr><td>UserName</td><td></td><td><input type=text name=username value=\"$user\"></td></tr>\n";
  print "<tr><td>Password</td><td></td><td><input type=password name=password></td></tr>\n";
  print "<tr><td></td><td></td><td><input type=submit name=login value=\"Go\"></td></tr>\n";
  print "</table>\n";
  print "</center><p>If you receive an ERROR message, please be sure that the UserName and password you just typed in is the same as the one used to access the internet.\n";

}
 

sub getdatetime {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);
  my @datemonths = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

  my $numidx = "01";
  my ($nummon);
  foreach my $mons (@datemonths) {
    if ($mon eq $mons) {
     $nummon = $numidx;
    }
    $numidx++;
  }

  return "$year-$nummon-$dayofmon $time";

}

sub formatseconds {

my $seconds = shift;
my $hours = 0;
my $minutes = 0;
my $ret = '';

while ($seconds >= 3600) {
 $seconds -= 3600;
 $hours += 1;
}

while ($seconds >= 60) {
 $seconds -= 60;
 $minutes += 1;
}
 $ret = "$hours"."h:" if $hours ne 0;

 $ret .= "$minutes"."m:".$seconds."s";
 return $ret;


}


sub error {

  my $error = shift;

   if ($error eq 'invalid') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>You have entered an invalid username and password combination.</font>\n";
     print "<br><font face=arial>Please try again.</font>\n";
     print "</body></html>\n";
   }

   exit;

}


sub auth {

  my $username = shift;
  my $password = shift;

  my $authsth = $dbh->prepare("SELECT id from radcheck where Attribute = \"Password\" and UserName = \"$username\" and Value = \"$password\"");
  $authsth->execute || print "error was ".$dbh->errstr;;
  my $result = $authsth->fetchrow_array;

  return 1 if $result;
  return 0;

}
