/*
 * BUFFER - Simple buffers (non-wrapping rings)
 *
 * Author:
 * Emile van Bergen, emile@e-advies.nl
 *
 * License:
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2006/02/15 - EvB - Created
 */


/* 
 * INCLUDES & DEFINES
 */


#include <malloc.h>
#include <string.h>

#include <evblib/buffer/buffer.h>


/*
 * FUNCTIONS
 */



BUF_T *buf_new(size_t size)
{
    BUF_T *ret;

    ret = (BUF_T *)malloc(sizeof(BUF_T)); if (!ret) return ret;
    if (!buf_init(ret, size)) { free(ret); return 0; }
    return ret;
}


int buf_init(BUF_T *b, size_t size)
{
    return (0 != (b->r = b->w = b->bu.p = (char *)malloc(b->bu.l = size)));
}


void buf_done(BUF_T *b)
{
    if (b->bu.p) { free(b->bu.p); b->bu.p = 0; }
}


void buf_del(BUF_T *b)
{
    buf_done(b);
    free(b);
}


/* I'm not your nanny. If you want to debug your heap handling, use valgrind. */


/* 
 * vim:softtabstop=4:sw=4 
 */
