/*
 * BUFFER - Simple buffers (non-wrapping rings)
 *
 * Theory is as follows. You get direct access to read and write pointers.
 * Readers are not allowed to read more than buf_maxget bytes. No checking.
 * After a reader is done, call buf_get to advance the read pointer and
 * reset it if the buffer was emptied.
 *
 * Writers are not allowed to write more than buf_maxput bytes. No checking.
 * After a writer is done writing, call buf_put to advance the write pointer
 * and make the buffered amount available to the reader.
 *
 * Author:
 * Emile van Bergen, emile@e-advies.nl
 *
 * License:
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2006/02/15 - EvB - Created
 */


/* 
 * INCLUDES & DEFINES
 */


#include <evblib/str/str.h>


#define buf_capacity(B)   ((B)->bu.l)
#define buf_maxget(B)	  ((B)->w - (B)->r)
#define buf_maxput(B)	  ((B)->bu.p + (B)->bu.l - (B)->w)
#define buf_empty(B)	  ((B)->r = (B)->w = (B)->bu.p)

#define buf_get(B,len) 	  (((B)->r += (len)) == (B)->w && buf_empty(B))
#define buf_put(B,len)	  ((B)->w += (len))


/* 
 * TYPES
 */


typedef struct buf {
    STR_T bu;
    char *r, *w;
} BUF_T;


/*
 * PROTOTYPES
 */


BUF_T *buf_new(size_t size);			/* malloc + init */
int buf_init(BUF_T *b, size_t size);
void buf_done(BUF_T *b);
void buf_del(BUF_T *b);				/* done + free */

