/* HTBL - a simple hash table */

#include <malloc.h>
#include <string.h>

#include <evblib/db/hashtable.h>


static void freeent(HTENT_T *ent)
{
	if (ent->flags & HTBL_PF_FREEKEY) FREESTR(ent->key);
	if (ent->flags & HTBL_PF_FREEDATA) FREESTR(ent->data);
	free(ent);
}


int htbl_init(HTBL_T *ht, hashval_t entries, htfunc_t f)
{
	ht->f = f;
	ht->mod = entries;
	ht->t = (HTHENT_T *)malloc(entries * sizeof(HTHENT_T));
	if (!ht->t) return -1;
	return 0;
}


void htbl_done(HTBL_T *ht)
{
	HTHENT_T *he;
	HTENT_T *ent, *nextent;

	if (!ht->t) return;

	for(he = ht->t; ht->mod; he++, ht->mod--) {
		for(ent = he->head; ent; ent = nextent)
		{
			nextent = ent->next;
			freeent(ent);
		}
		he->head = he->tail = 0;
	}

	free(ht->t);
	ht->t = 0;
}


HTENT_T *htbl_getent(HTBL_T *ht, char *key, ssize_t keyl, 
	          HTHENT_T **headent, hashval_t *hashval)
{
	hashval_t hv;
	HTHENT_T *he; 
	HTENT_T *ret;

	hv = ht->f(key, keyl);
	he = &ht->t[hv % ht->mod];
	if (hashval) *hashval = hv;
	if (headent) *headent = he;

	for(ret = he->head;
	    ret && (ret->hv != hv || 
		    ret->key.l != keyl || 
		    memcmp(ret->key.p, key, keyl));
	    ret = ret->next);

	return ret;
}


HTENT_T *htbl_addent(HTBL_T *ht, char *key, ssize_t keyl, 
	     char *data, ssize_t datal, int flags)
{
	hashval_t hv;
	HTHENT_T *he;

	hv = ht->f(key, keyl);
	he = &ht->t[hv % ht->mod];
	return hthe_addent(he, hv, key, keyl, data, datal, flags);
}


HTENT_T *hthe_addent(HTHENT_T *he, hashval_t hashval, char *key, ssize_t keyl, 
		  char *data, ssize_t datal, int flags)
{
	HTENT_T *ret;

	ret = (HTENT_T *)malloc(sizeof(HTENT_T));
	if (!ret) return ret;
	memset(ret, 0, sizeof(HTENT_T));
	ret->hv = hashval;
	ret->key.p = key;
	ret->key.l = keyl;
	ret->data.p = data;
	ret->data.l = datal;
	ret->flags = flags;
	if (flags & HTBL_PF_TOFRONT) {
		LIST_ADDHEAD(&he->head, &he->tail, ret);
		return ret;
	}
	LIST_ADDTAIL(&he->head, &he->tail, ret);
	return ret;
}


void hthe_delent(HTHENT_T *he, HTENT_T *ent)
{
	LIST_DEL(&he->head, &he->tail, ent);
	freeent(ent);
}

