/*
 * FASTRING - support for fast ring buffers using the mirror page technique
 *
 * Author:
 * Emile van Bergen, emile@e-advies.nl
 *
 * License:
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History: 
 * 2003/05/08 - EvB - Created
 */

char fastring_id[] = "FASTRING - Copyright (C) 2003 Emile van Bergen.";


#include <malloc.h>		/* for malloc, free */
#include <string.h>		/* for memset */

#include <evblib/fastring/fastring.h>


RING_T *ring_new(size_t size)
{
    RING_T *ret;

    ret = (RING_T *)malloc(sizeof(RING_T)); if (!ret) return 0;
    memset(ret, 0, sizeof(RING_T));
    if (mirr_new(size, &ret->mp) == 0) { free(ret); return 0; }
    ret->r = ret->w = ret->mp.p;
    return ret;
}

void ring_del(RING_T *r)
{
    mirr_del(&r->mp);
    free(r);
}
