/* This is the 'SuperFast' hash function by Paul Hsieh, taken from
 * http://www.azillionmonkeys.com/qed/hash.html and edited for cosmetics only.
 * The license is at http://www.azillionmonkeys.com/qed/weblicense.html and
 * appears to be fully GPL-compatible. If I'm wrong, please notify me (EvB). */


#include <evblib/hash/sfh.h>

/* On x86, unaligned 16 bit accesses are ok, on everthing else, they're not */

#undef get16bits
#if (defined(__GNUC__) && defined(__i386__)) || defined(__WATCOMC__) \
  || defined(_MSC_VER) || defined (__BORLANDC__) || defined (__TURBOC__)
#define get16bits(d) (*((uint16_t *) (d)))
#endif

#if !defined (get16bits)
#define get16bits(d) ((((uint8_t *)(d))[1] << 8)\
                      +((uint8_t *)(d))[0])
#endif

#define get8bits(d)  (*(uint8_t *)(d))


uint32_t sfh(void *data, ssize_t datal) 
{
    uint32_t hash = datal, tmp;
    int rem;

    if (datal <= 0 || !data) return 0;

    rem = datal & 3;
    datal >>= 2;

    /* Main loop */
    for (;datal > 0; datal--) {
        hash  += get16bits (data);
        tmp    = (get16bits (data + 2) << 11) ^ hash;
        hash   = (hash << 16) ^ tmp;
        data  += 4;
        hash  += hash >> 11;
    }

    /* Handle end cases */
    switch (rem) {
        case 3: hash += get16bits (data);
                hash ^= hash << 16;
                hash ^= get16bits (data + 2) << 18;
                hash += hash >> 11;
                break;
        case 2: hash += get16bits (data);
                hash ^= hash << 11;
                hash += hash >> 17;
                break;
        case 1: hash += get8bits (data);
                hash ^= hash << 10;
                hash += hash >> 1;
    }

    /* Force "avalanching" of final 127 bits */
    hash ^= hash << 3;
    hash += hash >> 5;
    hash ^= hash << 2;
    hash += hash >> 15;
    hash ^= hash << 10;

    return hash;
}
