/*
 * STREAM - Functions to support efficient I/O streams based on fastrings
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2004/01/13 - EvB - Created
 */


#include <evblib/fastring/fastring.h>
#include <evblib/str/str.h>

#define strm_advance(strm, amount)	ring_get((strm)->r, (amount))


typedef struct stream {
    RING_T *r;
    int fd, eof, aux;		/* line counter or other state info */
    size_t bufsize;
} STRM_T;


STRM_T *strm_new(int fd, ssize_t bufsize);
void strm_del(STRM_T *strm);

STR_T strm_getline(STRM_T *strm);
STR_T strm_ensure(STRM_T *strm, ssize_t len);
