#ifndef __BYTEORDER_H
#define __BYTEORDER_H 1

#include <evblib/sysdefs/systypes.h>


/* Try to establish endianness - supports BSD, GNU and SysV style */

#ifdef BYTE_ORDER       /* BSD */
#ifdef BIG_ENDIAN
#if BYTE_ORDER == BIG_ENDIAN
#define ISBIGENDIAN     1
#endif
#endif
#else   /* not BSD */

#ifdef __BYTE_ORDER     /* GNU */
#ifdef __BIG_ENDIAN
#if __BYTE_ORDER == __BIG_ENDIAN
#define ISBIGENDIAN     1
#endif
#endif
#else   /* not GNU */

#ifndef __386__         /* Some systems define this */

#ifdef _BIG_ENDIAN      /* Generic _BIG_ENDIAN */
#define ISBIGENDIAN     1
#else
#ifndef _LITTLE_ENDIAN
#error Cannot determine endianness! Please add a test for your system to misc/byteorder.h
#endif
#endif

#endif  /* QNX4 */
#endif  /* GNU */
#endif  /* BSD */


/* Conversion macros */

#ifdef ISBIGENDIAN

#define	net16(n)	((uint16_t)(n))
#define	net32(n)	((uint32_t)(n))

#else	/* not ISBIGENDIAN */

/* We want this because we don't want to depend on netinet for byteorder
 * conversion. Also, static inline is probably more portable than a macro
 * using local variables to prevent multiple parameter evaluation. In case
 * of portability problems, it's easy to remove inline and just incur some
 * extra performance hit. */

static inline uint16_t net16(uint16_t n)
{
	return ((n & (uint16_t)0x00ffU) << 8) |
	       ((n & (uint16_t)0xff00U) >> 8);
}

static inline uint32_t net32(uint32_t n)
{
	return ((n & (uint32_t)0x000000ffUL) << 24) |
	       ((n & (uint32_t)0x0000ff00UL) << 8)  |
	       ((n & (uint32_t)0x00ff0000UL) >> 8)  |
	       ((n & (uint32_t)0xff000000UL) >> 24);
}

#endif	/* ISBIGENDIAN */


#endif	/* __BYTEORDER_H */

