# Standard things

sp 		:= $(sp).x
dirstack_$(sp)	:= $(d)
d		:= $(dir)


# Local rules and targets

CF_$(d)		:= -I$(d) -Icommon -Ilanguage
LL_$(d)		:= common/common.a language/language.a

OBJS_$(d)	:= $(d)/config.o $(d)/jobs.o $(d)/channels.o $(d)/main.o
DEPS_$(d)	:= $(OBJS_$(d):%=%.d)

CLEAN		:= $(CLEAN) $(OBJS_$(d)) $(DEPS_$(d)) $(d)/defs.h \
		   $(d)/eapserver


# Local rules

$(OBJS_$(d)):	CF_TGT := $(CF_$(d))
$(OBJS_$(d)):	$(d)/Rules.mk $(d)/defs.h common/platform.h

$(d)/eapserver:	LL_TGT := $(S_LL_INET) $(S_LL_CRYPT)
$(d)/eapserver:	$(d)/main.o $(OBJS_$(d)) $(LL_$(d))
		$(LINK)

$(d)/%:		$(d)/%.o $(LL_$(d))
		$(LINK)

$(d)/defs.h: $(d)/Rules.mk
		$(DEFHDR) $@ $(S_CF_SIGACTION) \
			-DVERSION=\"eapserver-$(VERSION)\" \
			-DRADDB=\"$(DIR_ETC)/modules/eapserver\" \
			-DMODULES=\"$(DIR_LIB)\" \
			-DLOGFILE=\"$(FILE_LOG_EAPSRV)\"


# Standard things

-include	$(DEPS_$(d))

d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))

