#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <metadict.h>
#include <metaops.h>	/* For META_AV etc. */

#include <debug.h>


int main()
{
	char buf[C_MAX_MSGSIZE], pkt[C_MAX_PKTSIZE];
	META *m;
	META_SPC *spc;
	META_AV *avhead, *avtail, *avtree;
	int len;

	m = meta_newfromdict("../../raddb");
	if (!m) { msg(F_MISC, L_ERR,"main: ERROR: Couldn't open dictionary!\n");
		  return 1; }

	spc = meta_getspcbynr(m, C_DS_RAD_PKT);
	if (!spc) { msg(F_MISC, L_ERR, "main: ERROR: RAD-PKT not defined!\n");
		    return 1; }

	/* Get ASCII pairs from stdin into META_AV list */
	printf("Enter A/V pairs, one per line, terminated by ^D.\n");
	while(fgets(buf, C_MAX_MSGSIZE - 1, stdin)) {

		len = strlen(buf); if (buf[len - 1] == '\n') len--;
		meta_ascmsgtoav(m, buf, len, &avhead, &avtail, 0, 0);
	}

	/* Repeat list for clarity */
	write(2, "A/V list:\n", 10);
	meta_printavlist(m, avhead, 0);

	/* Buildtree using base space RAD_PKT */
	meta_buildtree(&avhead, &avtree, spc);
	write(2, "A/V tree:\n", 10);
	meta_printavlist(m, avtree, 0);
	meta_freeavlist(avhead); avhead = avtail = 0;

	/* Encode A/V tree in space RAD_PKT */
	len = meta_encode(spc, pkt, C_MAX_PKTSIZE, avtree, 0);
	if (len == -1) {
		msg(F_SEND, L_ERR, "main: Error encoding data!\n");
		return 2;
	}

	/* Show hexdump */
	fprintf(stderr, "Encoded (%d bytes):\n", len); fflush(stderr);
	hexdump(pkt, len);

	return 0;
}

