# Note: this design uses target-specific flags, because it's the only
# way to get the value of a variable that's different for each
# subdirectory, $(d), into the build recipes. Once you go that way,
# you can as well use the feature to specify (extra) objects and 
# libraries to be linked or archived.


# Standard stuff

VERSION		:= pre0.9.5

.SUFFIXES:
.SUFFIXES:	.c .o

all:		targets


# Subdirectories, in random order

dir	:= server
include		$(dir)/Rules.mk
dir	:= language
include		$(dir)/Rules.mk
dir 	:= common
include		$(dir)/Rules.mk
dir	:= modules
include		$(dir)/Rules.mk
dir	:= tools
include		$(dir)/Rules.mk
dir	:= raddb
include		$(dir)/Rules.mk


# General directory independent rules

%.o:		%.c
		$(COMP)

%:		%.o
		$(LINK)

%:		%.c
		$(COMPLINK)


# These two targets collect real targets, i.e. ones that can be built.

.PHONY:		targets
targets:	$(TGT_BIN) $(TGT_SBIN) $(TGT_ETC) $(TGT_LIB)

.PHONY:		testprogs
testprogs:	$(TGT_TEST)


# These targets merely contain commands to be executed, i.e. they collect
# only .PHONY targets, even if they're not explicitly marked as such. 
# The install target does not collect dependencies (other than for forcing
# things to be built) because it's always considered 'out of date' anway as
# it's a .PHONY target. Instead, it collects installation commands that will be
# ran in addition to the standard ones to install the known targets.

.PHONY:		clean
clean:
		rm -f $(CLEAN)

.PHONY:		install
install:	targets 
		$(INST) $(TGT_BIN) -m 755 -d $(DIR_BIN)
		$(CMD_INSTBIN)
		$(INST) $(TGT_SBIN) -m 750 -d $(DIR_SBIN)
		$(CMD_INSTSBIN)
ifeq ($(wildcard $(DIR_ETC)/*),)
		$(INST) $(TGT_ETC) -m 644 -d $(DIR_ETC)
		$(CMD_INSTETC)
else
		@echo Configuration directory $(DIR_ETC) already present -- skipping
endif
		$(INST) $(TGT_LIB) -m 750 -d $(DIR_LIB)
		$(CMD_INSTLIB)
		@echo
		@echo If no error messages appeared, OpenRADIUS is now installed successfully. 
		@echo To test the server, run it as the current user in foreground mode with 
		@echo debugging enabled, by typing: \'$(DIR_SBIN)/radiusd -dall -b\'.
		@echo


# Prevent make from removing any build targets, including intermediate ones

.SECONDARY:	$(CLEAN)

