/*
 * CHANNELS - Handles common operations on channels; also contains the code
 *            to process incoming data from them. For outgoing interface
 *            messages, we just use the generic meta_avtomsg() in metaops.c.
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/10/29 - EvB - Created
 */


/* 
 * INCLUDES & DEFINES
 */


#include <time.h>

#include <srvtypes.h>


/*
 * PROTOTYPES
 */


/* To be called when select says a channel's subprocess' pipe has data */

void chan_handle_read(CHAN *ch, time_t t);

/* To be called when select says a channel's subprocess' pipe has more room */

void chan_handle_write(CHAN *ch, time_t t);
