#include <mytypes.h>

/* Base classes for indexable things */

typedef struct naitem {
	ssize_t namel;
	NAME name;
	struct naitem *prev, *next;
} NAITEM;

typedef struct nritem {
	ORD nr;
	struct nritem *prev, *next;
} NRITEM;

typedef struct atrref {
	ORD spc, vnd, nr, tag;
	struct atrref *prev, *next;
} ATRREF;

/* The indexes themselves: all hashes */

typedef struct nridx {
	NRITEM **h;	/* hash */
	int m;		/* modulo */
} NRIDX;

typedef struct naidx {
	NAITEM **h;	/* hash */
	int m;		/* modulo */
} NAIDX;

typedef struct aridx {
	ATRREF **h;	/* hash */
	int m;		/* modulo */
} ARIDX;

/* Space */

typedef struct spc {
	NAITEM na;
	NRITEM nr;
	NRIDX v;	/* vendors for which this space has attributes */

	/* other space properties */
} SPC;

/* Vendor */

typedef struct vnd {
	NAITEM na;
	NRITEM nr;
	NRIDX a;	/* attributes of this vendor */
} VND;

/* Value; only attribute has a name- and numeric index to this */

typedef struct val {
	NAITEM na;
	NRITEM nr;
} VAL;

/* Attributes have three indexes: 
   - flat by name; optionally space, vendor and tag can be tested too */
   - flat by numeric ATRREF tuple (contains space, vendor, nr, tag)
   - hierarchical by number (space, vendor, attribute); tag can be tested too */

typedef struct atr {
	NAITEM na;	
	NRITEM nr;
	ATRREF ar;			/* allow indexing by spcnr, vndnr, nr */

	/* For finding parents */

	SPC *spc;
	VND *vnd;

	/* Other attribute properties */

	/* Values */

	NAIDX valna;
	NRIDX valnr;
} ATR;

/* Dictionary: access spaces, vendors, attributes by name and number; numeric 
   index for attributes is by spc, vnd, atr tuple (tag is zero not tested) */

typedef struct dict {
	NRIDX spcnr, vndnr;
	ARIDX atrref;
	NAIDX spcna, vndna, atrna;
} DICT;

/* NB. Enumerating items in dict (eg. for freeing) is done by walking the 
   hash array; hashes aren't sparse enough to warrant a separate linked 
   list. */

/* AV pairs, indexed using a ARIDX and by linked list */

typedef struct av {
	/* Attribute */

	ATRREF ar;		/* to compare when using the ARIDX, and may
				   also use a vendor and/or attribute number 
				   that does not exist; in that case 'atr' 
				   points to a wildcard attribute. */
	struct av *prev, *next;	/* in avlist's linked list */
	VND *vnd;		/* underlying vendor if only that is known */
	ATR *atr;		/* underlying attribute (possibly wildcard) */

	/* Value */

	char *p;
	ORD l;			/* overloaded length and numeric value */

	/* Flags */

	int flags;		/* see AV_*; most notable AV_FREE_P */
} AV;

/* REQ/REP list in VM: access by numeric tuple (from VM INSN); the simple
   (non-compiled language) ASCII module interfaces only adds to lists and 
   names used there are looked up in the dictionary, never in the VM lists. 
   We also need to keep a linked list in the VM to preserve ordering when 
   adding and encoding, and for quick freeing. */

typedef struct avlist { 
	ARIDX a;
	AV *head, *tail;
} AVLIST;

